/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedrest.http.request.handler;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.cyclops.cyclopscore.init.ModBaseNeoForge;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.INetworkElement;
import org.cyclops.integrateddynamics.core.persist.world.NetworkWorldStorage;
import org.cyclops.integratedrest.api.http.request.IRequestHandler;
import org.cyclops.integratedrest.json.JsonUtil;
import org.cyclops.integratedrest.vendors.io.netty.handler.codec.http.HttpMethod;
import org.cyclops.integratedrest.vendors.io.netty.handler.codec.http.HttpRequest;
import org.cyclops.integratedrest.vendors.io.netty.handler.codec.http.HttpResponseStatus;

public class NetworkRequestHandler
implements IRequestHandler {
    @Override
    public HttpResponseStatus handle(String[] path, HttpRequest request, JsonObject responseObject) {
        if (!request.method().equals(HttpMethod.GET)) {
            return HttpResponseStatus.BAD_REQUEST;
        }
        NetworkWorldStorage worldStorage = (NetworkWorldStorage)NetworkWorldStorage.Access.getInstance((ModBaseNeoForge)IntegratedDynamics._instance).get();
        if (path.length == 0) {
            JsonArray jsonNetworks = new JsonArray();
            for (INetwork network : worldStorage.getNetworks()) {
                JsonObject jsonNetwork = new JsonObject();
                JsonUtil.addNetworkInfo(jsonNetwork, network);
                jsonNetworks.add((JsonElement)jsonNetwork);
            }
            responseObject.addProperty("@id", JsonUtil.absolutizePath("/"));
            responseObject.add("networks", (JsonElement)jsonNetworks);
            return HttpResponseStatus.OK;
        }
        if (path.length == 1) {
            String networkHash = path[0];
            INetwork network = null;
            for (INetwork loopNetwork : worldStorage.getNetworks()) {
                if (!Integer.toString(loopNetwork.hashCode()).equals(networkHash)) continue;
                network = loopNetwork;
            }
            if (network != null) {
                JsonUtil.addNetworkInfo(responseObject, network);
                JsonArray jsonElements = new JsonArray();
                for (INetworkElement networkElement : network.getElements()) {
                    JsonObject jsonElement = new JsonObject();
                    JsonUtil.addNetworkElementInfo(jsonElement, networkElement, network);
                    jsonElements.add((JsonElement)jsonElement);
                }
                responseObject.add("elements", (JsonElement)jsonElements);
                return HttpResponseStatus.OK;
            }
        }
        return HttpResponseStatus.NOT_FOUND;
    }
}

