/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedrest.json;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integratedrest.api.json.IReverseValueTypeJsonHandler;
import org.cyclops.integratedrest.api.json.IValueTypeJsonHandler;
import org.cyclops.integratedrest.api.json.IValueTypeJsonHandlerRegistry;

public class ValueTypeJsonHandlerRegistry
implements IValueTypeJsonHandlerRegistry {
    private static ValueTypeJsonHandlerRegistry INSTANCE = new ValueTypeJsonHandlerRegistry();
    private final Map<IValueType<?>, IValueTypeJsonHandler<?>> handlers = Maps.newIdentityHashMap();
    private final List<IReverseValueTypeJsonHandler<?>> reverseHandlers = Lists.newArrayList();

    private ValueTypeJsonHandlerRegistry() {
    }

    public static ValueTypeJsonHandlerRegistry getInstance() {
        return INSTANCE;
    }

    @Override
    public <V extends IValue, T extends IValueType<V>> void registerHandler(T valueType, IValueTypeJsonHandler<V> handler) {
        this.handlers.put(valueType, handler);
    }

    @Override
    public <V extends IValue, T extends IValueType<V>> void registerReverseHandler(IReverseValueTypeJsonHandler<V> handler) {
        this.reverseHandlers.add(handler);
    }

    @Override
    @Nullable
    public <V extends IValue, T extends IValueType<V>> IValueTypeJsonHandler<V> getHandler(T valueType) {
        return this.handlers.get(valueType);
    }

    @Override
    @Nullable
    public Collection<IReverseValueTypeJsonHandler<?>> getReverseHandlers() {
        return Collections.unmodifiableList(this.reverseHandlers);
    }
}

