/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedrest.json;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.helper.IModHelpersNeoForge;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeBlock;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeEntity;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeFluidStack;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeItemStack;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeBoolean;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeCategoryAny;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeDouble;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeInteger;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeList;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeLong;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeNbt;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeString;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.helper.Helpers;
import org.cyclops.integratedrest.IntegratedRest;
import org.cyclops.integratedrest.api.json.IValueTypeJsonHandlerRegistry;
import org.cyclops.integratedrest.json.JsonUtil;
import org.cyclops.integratedrest.json.handler.CheckedValueTypeJsonHandlerBase;
import org.cyclops.integratedrest.json.handler.TypedObjectValueTypeJsonHandlerBase;

public class ValueTypeJsonHandlers {
    public static IValueTypeJsonHandlerRegistry REGISTRY = (IValueTypeJsonHandlerRegistry)IntegratedRest._instance.getRegistryManager().getRegistry(IValueTypeJsonHandlerRegistry.class);

    public static void load() {
        REGISTRY.registerHandler(ValueTypes.BOOLEAN, value -> new JsonPrimitive(Boolean.valueOf(value.getRawValue())));
        REGISTRY.registerReverseHandler(new CheckedValueTypeJsonHandlerBase<ValueTypeBoolean.ValueBoolean>(){

            @Override
            public ValueTypeBoolean.ValueBoolean handleUnchecked(JsonElement jsonElement) throws IllegalStateException, ClassCastException {
                return jsonElement instanceof JsonPrimitive && ((JsonPrimitive)jsonElement).isBoolean() ? ValueTypeBoolean.ValueBoolean.of((boolean)jsonElement.getAsBoolean()) : null;
            }
        });
        REGISTRY.registerHandler(ValueTypes.INTEGER, value -> new JsonPrimitive((Number)value.getRawValue()));
        REGISTRY.registerReverseHandler(new CheckedValueTypeJsonHandlerBase<ValueTypeInteger.ValueInteger>(){

            @Override
            public ValueTypeInteger.ValueInteger handleUnchecked(JsonElement jsonElement) throws IllegalStateException, ClassCastException {
                return jsonElement instanceof JsonPrimitive && ((JsonPrimitive)jsonElement).isNumber() ? ValueTypeInteger.ValueInteger.of((int)jsonElement.getAsInt()) : null;
            }
        });
        REGISTRY.registerHandler(ValueTypes.DOUBLE, value -> {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("@type", "http://www.w3.org/2001/XMLSchema#decimal");
            jsonObject.addProperty("@value", (Number)value.getRawValue());
            return jsonObject;
        });
        REGISTRY.registerReverseHandler(new TypedObjectValueTypeJsonHandlerBase<ValueTypeDouble.ValueDouble>("http://www.w3.org/2001/XMLSchema#decimal"){

            @Override
            protected ValueTypeDouble.ValueDouble handleTypedValueString(String valueString) {
                return ValueTypeDouble.ValueDouble.of((double)Double.valueOf(valueString));
            }
        });
        REGISTRY.registerHandler(ValueTypes.LONG, value -> {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("@type", "http://www.w3.org/2001/XMLSchema#long");
            jsonObject.addProperty("@value", (Number)value.getRawValue());
            return jsonObject;
        });
        REGISTRY.registerReverseHandler(new TypedObjectValueTypeJsonHandlerBase<ValueTypeLong.ValueLong>("http://www.w3.org/2001/XMLSchema#long"){

            @Override
            protected ValueTypeLong.ValueLong handleTypedValueString(String valueString) {
                return ValueTypeLong.ValueLong.of((long)Long.valueOf(valueString));
            }
        });
        REGISTRY.registerHandler(ValueTypes.STRING, value -> new JsonPrimitive(value.getRawValue()));
        REGISTRY.registerReverseHandler(new CheckedValueTypeJsonHandlerBase<ValueTypeString.ValueString>(){

            @Override
            public ValueTypeString.ValueString handleUnchecked(JsonElement jsonElement) throws IllegalStateException, ClassCastException {
                return ValueTypeString.ValueString.of((String)jsonElement.getAsString());
            }
        });
        REGISTRY.registerHandler(ValueTypes.LIST, value -> {
            if (value.getRawValue().isInfinite()) {
                JsonObject jsonObject = new JsonObject();
                jsonObject.addProperty("@type", "ValueInfiniteList");
                return jsonObject;
            }
            JsonArray jsonArray = new JsonArray();
            for (IValue v : value.getRawValue()) {
                jsonArray.add(JsonUtil.valueToJson(v));
            }
            return jsonArray;
        });
        REGISTRY.registerReverseHandler(new CheckedValueTypeJsonHandlerBase<ValueTypeList.ValueList>(){

            @Override
            public ValueTypeList.ValueList handleUnchecked(JsonElement jsonElement) throws IllegalStateException, ClassCastException {
                if (jsonElement instanceof JsonArray) {
                    ArrayList elements = Lists.newArrayList();
                    ValueTypeCategoryAny type = ValueTypes.CATEGORY_ANY;
                    JsonArray jsonArray = (JsonArray)jsonElement;
                    for (JsonElement element : jsonArray) {
                        JsonUtil.jsonToValue(element).ifPresent(elements::add);
                    }
                    if (elements.size() > 0) {
                        IValueType maybeType = ((IValue)elements.get(0)).getType();
                        if (elements.stream().map(IValue::getType).allMatch(arg_0 -> ((IValueType)maybeType).equals(arg_0))) {
                            type = maybeType;
                        }
                    }
                    return ValueTypeList.ValueList.ofList((IValueType)type, (List)elements);
                }
                return null;
            }
        });
        REGISTRY.registerHandler(ValueTypes.OPERATOR, value -> {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("@type", "ValueOperator");
            jsonObject.addProperty("@value", value.getRawValue().getUniqueName().toString());
            return jsonObject;
        });
        REGISTRY.registerHandler(ValueTypes.NBT, value -> {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("@type", "ValueNbt");
            jsonObject.add("nbt", new JsonParser().parse(((Tag)value.getRawValue().orElse(new CompoundTag())).toString()));
            return jsonObject;
        });
        REGISTRY.registerReverseHandler(new CheckedValueTypeJsonHandlerBase<ValueTypeNbt.ValueNbt>(){

            @Override
            public ValueTypeNbt.ValueNbt handleUnchecked(JsonElement jsonElement) throws IllegalStateException, ClassCastException {
                if (jsonElement instanceof JsonObject && ((JsonObject)jsonElement).has("@type") && ((JsonObject)jsonElement).get("@type").getAsString().equals("ValueNbt")) {
                    try {
                        return ValueTypeNbt.ValueNbt.of((Tag)((Tag)Helpers.TAG_PARSER.parseFully(((JsonObject)jsonElement).get("nbt").toString())));
                    }
                    catch (CommandSyntaxException e) {
                        throw new IllegalStateException(e);
                    }
                }
                return null;
            }
        });
        REGISTRY.registerHandler(ValueTypes.OBJECT_BLOCK, value -> {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("@type", "ValueBlock");
            if (value.getRawValue().isPresent()) {
                BlockState blockState = (BlockState)value.getRawValue().get();
                jsonObject.addProperty("block", JsonUtil.absolutizePath("registry/block/" + JsonUtil.resourceLocationToPath(BuiltInRegistries.BLOCK.getKey((Object)blockState.getBlock()))));
                jsonObject.addProperty("resourceLocation", BuiltInRegistries.BLOCK.getKey((Object)blockState.getBlock()).toString());
                jsonObject.addProperty("state", IModHelpers.get().getBlockHelpers().serializeBlockState(blockState).toString());
                JsonArray jsonProperties = new JsonArray();
                for (Property property : blockState.getProperties()) {
                    JsonObject jsonProperty = new JsonObject();
                    jsonProperty.addProperty("key", property.getName());
                    jsonProperty.addProperty("value", blockState.getValue(property).toString());
                    jsonProperties.add((JsonElement)jsonProperty);
                }
            }
            return jsonObject;
        });
        REGISTRY.registerReverseHandler(new CheckedValueTypeJsonHandlerBase<ValueObjectTypeBlock.ValueBlock>(){

            @Override
            public ValueObjectTypeBlock.ValueBlock handleUnchecked(JsonElement jsonElement) throws IllegalStateException, ClassCastException {
                if (jsonElement instanceof JsonObject && ((JsonObject)jsonElement).has("@type") && ((JsonObject)jsonElement).get("@type").getAsString().equals("ValueBlock")) {
                    JsonObject jsonObject = (JsonObject)jsonElement;
                    if (jsonObject.has("state")) {
                        try {
                            return ValueObjectTypeBlock.ValueBlock.of((BlockState)IModHelpers.get().getBlockHelpers().deserializeBlockState(IModHelpers.get().getBlockHelpers().getHolderGetter(), TagParser.parseCompoundFully((String)jsonObject.get("state").getAsString())));
                        }
                        catch (CommandSyntaxException e) {
                            throw new IllegalStateException(e);
                        }
                    }
                    if (jsonObject.has("resourceLocation")) {
                        ResourceLocation resourceLocation = ResourceLocation.parse((String)jsonObject.get("resourceLocation").getAsString());
                        Block block = (Block)BuiltInRegistries.BLOCK.getValue(resourceLocation);
                        return ValueObjectTypeBlock.ValueBlock.of((BlockState)block.defaultBlockState());
                    }
                    return ValueObjectTypeBlock.ValueBlock.of(null);
                }
                return null;
            }
        });
        REGISTRY.registerHandler(ValueTypes.OBJECT_ITEMSTACK, value -> {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("@type", "ValueItem");
            if (!value.getRawValue().isEmpty()) {
                ItemStack itemStack = value.getRawValue();
                jsonObject.addProperty("item", JsonUtil.absolutizePath("registry/item/" + JsonUtil.resourceLocationToPath(BuiltInRegistries.ITEM.getKey((Object)itemStack.getItem()))));
                jsonObject.addProperty("resourceLocation", BuiltInRegistries.ITEM.getKey((Object)itemStack.getItem()).toString());
                jsonObject.addProperty("count", (Number)itemStack.getCount());
                CompoundTag data = ValueTypeJsonHandlers.getComponentsAsNbt(itemStack.getComponentsPatch());
                if (!data.isEmpty()) {
                    jsonObject.add("nbt", new JsonParser().parse(data.toString()));
                }
            }
            return jsonObject;
        });
        REGISTRY.registerReverseHandler(new CheckedValueTypeJsonHandlerBase<ValueObjectTypeItemStack.ValueItemStack>(){

            @Override
            public ValueObjectTypeItemStack.ValueItemStack handleUnchecked(JsonElement jsonElement) throws IllegalStateException, ClassCastException {
                if (jsonElement instanceof JsonObject && ((JsonObject)jsonElement).has("@type") && ((JsonObject)jsonElement).get("@type").getAsString().equals("ValueItem")) {
                    JsonObject jsonObject = (JsonObject)jsonElement;
                    if (!jsonObject.has("resourceLocation")) {
                        return ValueObjectTypeItemStack.ValueItemStack.of((ItemStack)ItemStack.EMPTY);
                    }
                    ResourceLocation resourceLocation = ResourceLocation.parse((String)jsonObject.get("resourceLocation").getAsString());
                    Item item = (Item)BuiltInRegistries.ITEM.getValue(resourceLocation);
                    if (item != null) {
                        int count = 1;
                        if (jsonObject.has("count")) {
                            count = jsonObject.get("count").getAsInt();
                        }
                        int meta = 0;
                        if (jsonObject.has("meta")) {
                            meta = jsonObject.get("meta").getAsInt();
                        }
                        DataComponentPatch data = DataComponentPatch.EMPTY;
                        if (jsonObject.has("nbt")) {
                            CompoundTag tag;
                            try {
                                tag = TagParser.parseCompoundFully((String)jsonObject.get("nbt").toString());
                            }
                            catch (CommandSyntaxException e) {
                                throw new IllegalStateException(e);
                            }
                            data = ValueTypeJsonHandlers.getNbtAsComponents(tag);
                        }
                        ItemStack itemStack = new ItemStack(Holder.direct((Object)item), count, data);
                        return ValueObjectTypeItemStack.ValueItemStack.of((ItemStack)itemStack);
                    }
                }
                return null;
            }
        });
        REGISTRY.registerHandler(ValueTypes.OBJECT_ENTITY, value -> {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("@type", "ValueEntity");
            if (value.getUuid().isPresent()) {
                jsonObject.addProperty("uuid", ((UUID)value.getUuid().get()).toString());
            }
            return jsonObject;
        });
        REGISTRY.registerReverseHandler(new CheckedValueTypeJsonHandlerBase<ValueObjectTypeEntity.ValueEntity>(){

            @Override
            public ValueObjectTypeEntity.ValueEntity handleUnchecked(JsonElement jsonElement) throws IllegalStateException, ClassCastException {
                if (jsonElement instanceof JsonObject && ((JsonObject)jsonElement).has("@type") && ((JsonObject)jsonElement).get("@type").getAsString().equals("ValueEntity")) {
                    if (((JsonObject)jsonElement).has("uuid")) {
                        try {
                            String uuid = ((JsonObject)jsonElement).get("uuid").getAsString();
                            return ValueObjectTypeEntity.ValueEntity.of((UUID)UUID.fromString(uuid));
                        }
                        catch (IllegalArgumentException e) {
                            throw new IllegalStateException(e);
                        }
                    }
                    return ValueObjectTypeEntity.ValueEntity.of((UUID)null);
                }
                return null;
            }
        });
        REGISTRY.registerHandler(ValueTypes.OBJECT_FLUIDSTACK, value -> {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("@type", "ValueFluid");
            if (!value.getRawValue().isEmpty()) {
                FluidStack fluidStack = value.getRawValue();
                jsonObject.addProperty("fluid", JsonUtil.absolutizePath("registry/fluid/" + String.valueOf(BuiltInRegistries.FLUID.getKey((Object)fluidStack.getFluid()))));
                jsonObject.addProperty("fluidName", BuiltInRegistries.FLUID.getKey((Object)fluidStack.getFluid()).toString());
                jsonObject.addProperty("count", (Number)fluidStack.getAmount());
                CompoundTag data = ValueTypeJsonHandlers.getComponentsAsNbt(fluidStack.getComponentsPatch());
                if (!data.isEmpty()) {
                    jsonObject.add("nbt", new JsonParser().parse(data.toString()));
                }
            }
            return jsonObject;
        });
        REGISTRY.registerReverseHandler(new CheckedValueTypeJsonHandlerBase<ValueObjectTypeFluidStack.ValueFluidStack>(){

            @Override
            public ValueObjectTypeFluidStack.ValueFluidStack handleUnchecked(JsonElement jsonElement) throws IllegalStateException, ClassCastException {
                if (jsonElement instanceof JsonObject && ((JsonObject)jsonElement).has("@type") && ((JsonObject)jsonElement).get("@type").getAsString().equals("ValueFluid")) {
                    JsonObject jsonObject = (JsonObject)jsonElement;
                    if (!jsonObject.has("fluidName")) {
                        return ValueObjectTypeFluidStack.ValueFluidStack.of((FluidStack)FluidStack.EMPTY);
                    }
                    Fluid fluid = (Fluid)BuiltInRegistries.FLUID.getValue(ResourceLocation.parse((String)jsonObject.get("fluidName").getAsString()));
                    if (fluid != null) {
                        int count = IModHelpersNeoForge.get().getFluidHelpers().getBucketVolume();
                        if (jsonObject.has("count")) {
                            count = jsonObject.get("count").getAsInt();
                        }
                        DataComponentPatch data = DataComponentPatch.EMPTY;
                        if (jsonObject.has("nbt")) {
                            CompoundTag tag;
                            try {
                                tag = TagParser.parseCompoundFully((String)jsonObject.get("nbt").toString());
                            }
                            catch (CommandSyntaxException e) {
                                throw new IllegalStateException(e);
                            }
                            data = ValueTypeJsonHandlers.getNbtAsComponents(tag);
                        }
                        FluidStack fluidStack = new FluidStack(Holder.direct((Object)fluid), count, data);
                        return ValueObjectTypeFluidStack.ValueFluidStack.of((FluidStack)fluidStack);
                    }
                }
                return null;
            }
        });
    }

    public static CompoundTag getComponentsAsNbt(DataComponentPatch dataComponentPatch) {
        return (CompoundTag)DataComponentPatch.CODEC.encodeStart((DynamicOps)ServerLifecycleHooks.getCurrentServer().registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)dataComponentPatch).getOrThrow();
    }

    public static DataComponentPatch getNbtAsComponents(CompoundTag compoundTag) {
        return (DataComponentPatch)((Pair)DataComponentPatch.CODEC.decode((DynamicOps)ServerLifecycleHooks.getCurrentServer().registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)compoundTag).getOrThrow()).getFirst();
    }
}

