/*
 * Decompiled with CFR 0.152.
 */
package dev.potota.itemstats;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.UnboundedMapCodec;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9299;
import net.minecraft.class_9473;
import org.jetbrains.annotations.NotNull;

public record StatsComponent(Map<class_2960, Double> stats) implements class_9299
{
    public static final Codec<StatsComponent> CODEC = new UnboundedMapCodec(class_2960.field_25139, (Codec)Codec.DOUBLE).xmap(StatsComponent::forceHashMap, StatsComponent::stats);
    public static final class_9139<ByteBuf, StatsComponent> STREAM_CODEC = class_9135.method_57992(maxSize -> new HashMap(), (class_9139)class_2960.field_48267, (class_9139)class_9135.field_48553, (int)256).method_56432(StatsComponent::forceHashMap, StatsComponent::stats);

    public StatsComponent(StatsComponent other) {
        this(new HashMap<class_2960, Double>(other.stats));
    }

    public void method_57409(@NotNull class_1792.class_9635 tooltipContext, @NotNull Consumer<class_2561> consumer, @NotNull class_1836 tooltipFlag, @NotNull class_9473 componentGetter) {
        this.stats.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEachOrdered(stat -> {
            class_2960 statId = (class_2960)stat.getKey();
            double value = (Double)stat.getValue();
            String translationId = String.format("item_stat.%s.%s", statId.method_12836(), statId.method_12832());
            if (value % 1.0 == 0.0) {
                consumer.accept((class_2561)class_2561.method_43469((String)translationId, (Object[])new Object[]{(int)value}).method_27692(class_124.field_1063));
            } else {
                String roundedValue = String.format("%.1f", value);
                consumer.accept((class_2561)class_2561.method_43469((String)translationId, (Object[])new Object[]{roundedValue}).method_27692(class_124.field_1063));
            }
        });
    }

    public static StatsComponent empty() {
        return new StatsComponent(new HashMap<class_2960, Double>());
    }

    private static StatsComponent forceHashMap(Map<class_2960, Double> map) {
        return new StatsComponent(new HashMap<class_2960, Double>(map));
    }

    public void incrementStat(class_2960 statId, double amount) {
        this.stats.merge(statId, amount, Double::sum);
    }

    public void incrementStat(class_2960 statId) {
        this.incrementStat(statId, 1.0);
    }
}

