/*
 * Decompiled with CFR 0.152.
 */
package dev.potota.itemstats;

import dev.potota.itemstats.ItemStat;
import dev.potota.itemstats.StatsComponent;
import dev.potota.itemstats.platform.Services;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemStats {
    static final String MOD_ID = "itemstats";
    private static final Logger LOG = LoggerFactory.getLogger((String)"Item Stat Tracker");
    public static final ResourceKey<Registry<ItemStat>> STAT_REGISTRY_KEY = ResourceKey.createRegistryKey((ResourceLocation)ItemStats.id("stat"));
    public static final Registry<ItemStat> STAT_REGISTRY = Services.PLATFORM.createRegistry(STAT_REGISTRY_KEY);
    public static final DataComponentType<StatsComponent> STATS_COMPONENT = (DataComponentType)Registry.register((Registry)BuiltInRegistries.DATA_COMPONENT_TYPE, (ResourceLocation)ItemStats.id("stats"), (Object)DataComponentType.builder().persistent(StatsComponent.CODEC).build());

    static ResourceLocation id(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }

    public static void incrementStat(ItemStack stack, ResourceLocation statId) {
        ItemStats.incrementStat(stack, statId, 1.0);
    }

    public static void incrementStat(ItemStack stack, ResourceLocation statId, double amount) {
        StatsComponent stats = (StatsComponent)stack.get(STATS_COMPONENT);
        if (stats != null) {
            StatsComponent newStats = new StatsComponent(stats);
            newStats.incrementStat(statId, amount);
            stack.set(STATS_COMPONENT, (Object)newStats);
        }
    }

    static void logInfo(String format, Object ... arguments) {
        format = "(Item Stat Tracker) " + (String)format;
        LOG.info((String)format, arguments);
    }
}

