/*
 * Decompiled with CFR 0.152.
 */
package dev.potota.itemstats.mixin;

import dev.potota.itemstats.BuiltInStats;
import dev.potota.itemstats.ItemStat;
import dev.potota.itemstats.ItemStats;
import dev.potota.itemstats.StatsComponent;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemStack.class})
public abstract class ItemStackMixin {
    @Final
    @Shadow
    PatchedDataComponentMap components;

    @Inject(method={"<init>(Lnet/minecraft/world/level/ItemLike;ILnet/minecraft/core/component/PatchedDataComponentMap;)V"}, at={@At(value="RETURN")})
    private void itemstats$addDefaultStats(ItemLike itemLike, int count, PatchedDataComponentMap components, CallbackInfo ci) {
        StatsComponent currentStats = (StatsComponent)components.get(ItemStats.STATS_COMPONENT);
        if (currentStats == null) {
            return;
        }
        StatsComponent newStats = new StatsComponent(currentStats);
        Item item = itemLike.asItem();
        for (Map.Entry registeredStat : ItemStats.STAT_REGISTRY.entrySet()) {
            TagKey<Item> appliesTo = ((ItemStat)registeredStat.getValue()).appliesTo();
            if (!item.builtInRegistryHolder().is(appliesTo)) continue;
            newStats.stats().putIfAbsent(((ResourceKey)registeredStat.getKey()).location(), 0.0);
        }
        this.components.set(ItemStats.STATS_COMPONENT, (Object)newStats);
    }

    @Inject(method={"mineBlock"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;awardStat(Lnet/minecraft/stats/Stat;)V")})
    private void itemstats$blockMined(Level pLevel, BlockState pState, BlockPos pPos, Player pPlayer, CallbackInfo ci) {
        ItemStack stack = (ItemStack)this;
        ItemStats.incrementStat(stack, BuiltInStats.Ids.BLOCKS_MINED);
    }
}

