/*
 * Decompiled with CFR 0.152.
 */
package dev.potota.itemstats.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import dev.potota.itemstats.BuiltInStats;
import dev.potota.itemstats.ItemStats;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerPlayer.class})
public abstract class ServerPlayerMixin
extends LivingEntity {
    private ServerPlayerMixin(EntityType<? extends LivingEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"checkMovementStatistics"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayer;awardStat(Lnet/minecraft/resources/ResourceLocation;I)V")}, slice={@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayer;isFallFlying()Z"), to=@At(value="CONSTANT", args={"intValue=25"}))})
    private void itemstats$distanceFlown(double dx, double dy, double dz, CallbackInfo ci, @Local int distanceCM) {
        ItemStack chestArmor = this.getItemBySlot(EquipmentSlot.CHEST);
        if (chestArmor.is(BuiltInStats.DISTANCE_FLOWN.appliesTo())) {
            ItemStats.incrementStat(chestArmor, BuiltInStats.Ids.DISTANCE_FLOWN, (double)distanceCM / 100.0);
        }
    }
}

