/*
 * Decompiled with CFR 0.152.
 */
package dev.potota.itemstats.mixin.neoforge;

import dev.potota.itemstats.BuiltInStats;
import dev.potota.itemstats.ItemStats;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.CombatRules;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.damagesource.DamageContainer;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Player.class})
public abstract class PlayerMixin
extends LivingEntity {
    private PlayerMixin(EntityType<? extends LivingEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"actuallyHurt"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;getDamageAfterMagicAbsorb(Lnet/minecraft/world/damagesource/DamageSource;F)F")})
    private void itemstats$trackDamageAbsorbedByArmor(DamageSource damageSource, float originalDamage, CallbackInfo ci) {
        float damageAfterArmor = ((DamageContainer)this.damageContainers.peek()).getNewDamage();
        float damageAbsorbedByAllArmor = originalDamage - damageAfterArmor;
        if (Math.abs(damageAbsorbedByAllArmor) < 1.0E-4f) {
            return;
        }
        Player player = (Player)this;
        int totalArmor = player.getArmorValue();
        for (ItemStack armorItem : player.getArmorSlots()) {
            if (armorItem.isEmpty()) continue;
            double armorValue = PlayerMixin.getArmorValue(armorItem, player.getEquipmentSlotForItem(armorItem));
            double fractionOfTotalArmor = armorValue / (double)totalArmor;
            ItemStats.incrementStat(armorItem, BuiltInStats.Ids.DAMAGE_ABSORBED, fractionOfTotalArmor * (double)damageAbsorbedByAllArmor);
        }
        if (damageSource.is(DamageTypeTags.BYPASSES_ENCHANTMENTS)) {
            return;
        }
        Level level = player.level();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            for (ItemStack armorItem : player.getArmorSlots()) {
                ItemEnchantments itemEnchantments;
                if (armorItem.isEmpty() || (itemEnchantments = (ItemEnchantments)armorItem.get(DataComponents.ENCHANTMENTS)) == null || itemEnchantments.isEmpty()) continue;
                MutableFloat damageProtection = new MutableFloat(0.0f);
                for (Object2IntMap.Entry entry : itemEnchantments.entrySet()) {
                    Holder holder = (Holder)entry.getKey();
                    if (!((Enchantment)holder.value()).matchingSlot(player.getEquipmentSlotForItem(armorItem))) continue;
                    int enchantmentLevel = entry.getIntValue();
                    ((Enchantment)holder.value()).modifyDamageProtection(level2, enchantmentLevel, armorItem, (Entity)player, damageSource, damageProtection);
                }
                float damageAfterEnchantments = CombatRules.getDamageAfterMagicAbsorb((float)damageAfterArmor, (float)damageProtection.getValue().floatValue());
                float damageAbsorbed = damageAfterArmor - damageAfterEnchantments;
                ItemStats.incrementStat(armorItem, BuiltInStats.Ids.DAMAGE_ABSORBED, damageAbsorbed);
            }
        }
    }

    @Unique
    private static double getArmorValue(ItemStack stack, EquipmentSlot slot) {
        AtomicReference<Double> value = new AtomicReference<Double>(0.0);
        stack.forEachModifier(slot, (attribute, modifier) -> {
            if (attribute.equals((Object)Attributes.ARMOR) && modifier.operation().equals((Object)AttributeModifier.Operation.ADD_VALUE)) {
                value.updateAndGet(v -> v + modifier.amount());
            }
        });
        return value.get();
    }
}

