/*
 * Decompiled with CFR 0.152.
 */
package dev.potota.itemstats.mixin.neoforge;

import dev.potota.itemstats.BuiltInStats;
import dev.potota.itemstats.ItemStats;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AxeItem.class})
public abstract class AxeItemMixin {
    @Unique
    private ItemStack stack;

    @Inject(method={"useOn"}, at={@At(value="HEAD")})
    private void itemstats$storeStack(UseOnContext context, CallbackInfoReturnable<InteractionResult> cir) {
        this.stack = context.getItemInHand();
    }

    @Inject(method={"evaluateNewBlockState"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;playSound(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/core/BlockPos;Lnet/minecraft/sounds/SoundEvent;Lnet/minecraft/sounds/SoundSource;FF)V", ordinal=0)})
    private void itemstats$logStripped(Level level, BlockPos pos, Player player, BlockState state, UseOnContext p_40529_, CallbackInfoReturnable<Optional<BlockState>> cir) {
        ItemStats.incrementStat(this.stack, BuiltInStats.Ids.LOGS_STRIPPED);
    }
}

