/*
 * Decompiled with CFR 0.152.
 */
package dev.potota.itemstats;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.UnboundedMapCodec;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipProvider;
import org.jetbrains.annotations.NotNull;

public record StatsComponent(Map<ResourceLocation, Double> stats) implements TooltipProvider
{
    public static final Codec<StatsComponent> CODEC = new UnboundedMapCodec(ResourceLocation.CODEC, (Codec)Codec.DOUBLE).xmap(StatsComponent::forceHashMap, StatsComponent::stats);
    public static final StreamCodec<ByteBuf, StatsComponent> STREAM_CODEC = ByteBufCodecs.map(maxSize -> new HashMap(), (StreamCodec)ResourceLocation.STREAM_CODEC, (StreamCodec)ByteBufCodecs.DOUBLE, (int)256).map(StatsComponent::forceHashMap, StatsComponent::stats);

    public StatsComponent(StatsComponent other) {
        this(new HashMap<ResourceLocation, Double>(other.stats));
    }

    public void addToTooltip(@NotNull Item.TooltipContext tooltipContext, @NotNull Consumer<Component> consumer, @NotNull TooltipFlag tooltipFlag, @NotNull DataComponentGetter componentGetter) {
        this.stats.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEachOrdered(stat -> {
            ResourceLocation statId = (ResourceLocation)stat.getKey();
            double value = (Double)stat.getValue();
            String translationId = String.format("item_stat.%s.%s", statId.getNamespace(), statId.getPath());
            if (value % 1.0 == 0.0) {
                consumer.accept((Component)Component.translatable((String)translationId, (Object[])new Object[]{(int)value}).withStyle(ChatFormatting.DARK_GRAY));
            } else {
                String roundedValue = String.format("%.1f", value);
                consumer.accept((Component)Component.translatable((String)translationId, (Object[])new Object[]{roundedValue}).withStyle(ChatFormatting.DARK_GRAY));
            }
        });
    }

    public static StatsComponent empty() {
        return new StatsComponent(new HashMap<ResourceLocation, Double>());
    }

    private static StatsComponent forceHashMap(Map<ResourceLocation, Double> map) {
        return new StatsComponent(new HashMap<ResourceLocation, Double>(map));
    }

    public void incrementStat(ResourceLocation statId, double amount) {
        this.stats.merge(statId, amount, Double::sum);
    }

    public void incrementStat(ResourceLocation statId) {
        this.incrementStat(statId, 1.0);
    }
}

