/*
 * Decompiled with CFR 0.152.
 */
package nnhomoli.api.abstractedutilities;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class GenericObjectIterator<T> {
    private final List<T> fields = new ArrayList<T>();

    public GenericObjectIterator<T> readStaticFields(Class<?> clazz, Class<?> instance) {
        try {
            for (Field f : clazz.getFields()) {
                if (!f.getType().isAssignableFrom(instance) || !Modifier.isStatic(f.getModifiers())) continue;
                this.fields.add(f.get(null));
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public void forEach(Consumer<T> action) {
        for (T f : this.fields) {
            action.accept(f);
        }
    }

    public void forEachWith(Predicate<T> predicate, Consumer<T> action) {
        for (T f : this.fields) {
            if (!predicate.test(f)) continue;
            action.accept(f);
        }
    }

    public void forEachExcept(Collection<T> except, Consumer<T> action) {
        for (T f : this.fields) {
            if (except.contains(f)) continue;
            action.accept(f);
        }
    }

    public T getRandom() {
        return this.fields.get(ThreadLocalRandom.current().nextInt(this.fields.size()));
    }

    public T getRandomWith(Predicate<T> predicate) {
        ArrayList<T> dupe = new ArrayList<T>();
        for (T f : this.fields) {
            if (!predicate.test(f)) continue;
            dupe.add(f);
        }
        return (T)dupe.get(ThreadLocalRandom.current().nextInt(dupe.size()));
    }

    public T getRandomExcept(Collection<T> except) {
        ArrayList<T> dupe = new ArrayList<T>(this.fields);
        dupe.removeAll(except);
        return (T)dupe.get(ThreadLocalRandom.current().nextInt(dupe.size()));
    }

    public List<T> getList() {
        return this.fields;
    }

    public T[] asArray() {
        return this.fields.toArray();
    }

    public int size() {
        return this.fields.size();
    }
}

