/*
 * Decompiled with CFR 0.152.
 */
package nnhomoli.api.abstractedutilities.annotations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import nnhomoli.api.abstractedutilities.annotations.MapperRestricted;

@Target(value={ElementType.TYPE})
@Retention(value=RetentionPolicy.RUNTIME)
public @interface MapperAccess {
    public FieldVisibility value() default FieldVisibility.DEFAULT;

    public static enum FieldVisibility {
        ALL,
        PUBLIC,
        EXCEPT_PRIVATE,
        DEFAULT;


        private boolean isVisibleClassWide(Member member) {
            return switch (this.ordinal()) {
                case 0 -> true;
                case 1 -> Modifier.isPublic(member.getModifiers());
                case 2 -> {
                    if (!Modifier.isPrivate(member.getModifiers())) {
                        yield true;
                    }
                    yield false;
                }
                default -> false;
            };
        }

        public boolean isVisible(Field member) {
            return !member.isAnnotationPresent(MapperRestricted.class) && this.isVisibleClassWide(member) || member.isAnnotationPresent(MapperAccess.class);
        }
    }
}

