/*
 * Decompiled with CFR 0.152.
 */
package nnhomoli.api.abstractedutilities;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import nnhomoli.api.abstractedutilities.AbstractedUtilities;

public record SafeMapper(ObjectMapper mapper) {
    public <T> T readOrWrite(File file, T value, Class<T> clazz) {
        if (file.exists()) {
            try {
                return (T)this.mapper.readValue(file, clazz);
            }
            catch (IOException e) {
                AbstractedUtilities.logger.info("Failed to read {}! {}", (Object)file.getName(), (Object)e.getMessage());
            }
        }
        if (file.getParentFile().mkdirs()) {
            AbstractedUtilities.logger.info("Created dirs for file {}", (Object)file.getName());
        }
        try {
            this.mapper.writeValue(file, value);
        }
        catch (IOException e) {
            AbstractedUtilities.logger.info("Failed to write new {}! {}", (Object)file.getName(), (Object)e.getMessage());
        }
        return value;
    }
}

