/*
 * Decompiled with CFR 0.152.
 */
package nnhomoli.api.abstractedutilities.cmd;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
abstract class Serializable {
    static final Map<String, Supplier<ArgumentType<?>>> MAP = new HashMap();

    Serializable() {
    }

    @Nullable
    static Class<?> classOrNull(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    static String ensurePackage(String pkg) {
        switch (pkg) {
            case "int": {
                pkg = "java.lang.Integer";
                break;
            }
            case "double": {
                pkg = "java.lang.Double";
                break;
            }
            case "boolean": {
                pkg = "java.lang.Boolean";
                break;
            }
            case "float": {
                pkg = "java.lang.Float";
            }
        }
        return pkg;
    }

    static {
        MAP.put("java.lang.String", StringArgumentType::string);
        MAP.put("java.lang.Integer", IntegerArgumentType::integer);
        MAP.put("java.lang.Float", FloatArgumentType::floatArg);
        MAP.put("java.lang.Double", DoubleArgumentType::doubleArg);
        MAP.put("java.lang.Boolean", BoolArgumentType::bool);
    }
}

