/*
 * Decompiled with CFR 0.152.
 */
package me.juancarloscp52.bedrockify.client.features.bedrockShading;

import com.google.common.collect.Maps;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import me.juancarloscp52.bedrockify.Bedrockify;
import me.juancarloscp52.bedrockify.client.BedrockifyClient;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_156;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import org.jetbrains.annotations.NotNull;
import org.joml.Math;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public final class BedrockSunGlareShading {
    private static final Map<String, ClassMethodHolder> MOD_ID_CLASS_MAP = (Map)class_156.method_654((Object)Maps.newHashMap(), map -> map.put("iris", new ClassMethodHolder("net.irisshaders.iris.Iris", "getCurrentPack", new Object[0], pack -> ((Optional)pack).isPresent())));
    private static final List<ClassMethodHolder> METHOD_INVOCATION_FAILED_LIST = new ArrayList<ClassMethodHolder>();
    private static final float DELTA_CLAMP_MIN = 0.0f;
    private static final float DELTA_CLAMP_MAX = 1.0f;
    private ShaderState shaderState = ShaderState.UNSPECIFIED;
    private float sunIntensityDelta;
    private float sunAngleDiff;
    private float sunBrightnessDelta;
    private final Vector3f sunVector3f;
    private final class_310 client;

    public BedrockSunGlareShading() {
        this.onSunlightIntensityChanged();
        this.sunVector3f = new Vector3f();
        this.client = class_310.method_1551();
    }

    public boolean shouldApplyShading() {
        return this.shaderState == ShaderState.VANILLA && BedrockifyClient.getInstance().settings.bedrockShading && this.sunIntensityDelta > 0.0f;
    }

    public void reloadCustomShaderState() {
        this.shaderState = this.fetchShaderStateInternal();
    }

    private ShaderState fetchShaderStateInternal() {
        if (FabricLoader.getInstance().isModLoaded("optifabric")) {
            return ShaderState.EXTERNAL;
        }
        boolean enabled = false;
        for (Map.Entry<String, ClassMethodHolder> entry : MOD_ID_CLASS_MAP.entrySet()) {
            String modId = entry.getKey();
            if (!FabricLoader.getInstance().isModLoaded(modId)) continue;
            ClassMethodHolder holder = entry.getValue();
            if (METHOD_INVOCATION_FAILED_LIST.contains(holder)) {
                return ShaderState.INVOCATION_FAILED;
            }
            if (holder.canonicalName.isEmpty() || holder.methodName.isEmpty() || holder.methodArgs == null) {
                enabled |= holder.condition.test(null);
                continue;
            }
            try {
                Class<?> clazz = Class.forName(holder.canonicalName);
                Method invoker = clazz.getMethod(holder.methodName, (Class[])Arrays.stream(holder.methodArgs).map(Object::getClass).toArray(Class[]::new));
                invoker.setAccessible(true);
                enabled |= holder.condition.test(invoker.invoke(clazz, holder.methodArgs));
            }
            catch (Throwable ex) {
                if (!METHOD_INVOCATION_FAILED_LIST.contains(holder)) {
                    METHOD_INVOCATION_FAILED_LIST.add(holder);
                    String message = String.format("[%s] method invocation failed into \"%s::%s(%s)\", provided by the mod \"%s\".", Bedrockify.class.getSimpleName(), holder.canonicalName, holder.methodName, Arrays.stream(holder.methodArgs).map(arg -> arg.getClass().getSimpleName()).collect(Collectors.joining(", ")), modId);
                    BedrockifyClient.LOGGER.error(message, ex);
                }
                if (this.shaderState != ShaderState.INVOCATION_FAILED) {
                    BedrockifyClient.LOGGER.warn("[{}] Shader mod is present, but cannot determine the shader state. BedrockIfy Sun Glare Shading is now disabled.", (Object)Bedrockify.class.getSimpleName());
                }
                return ShaderState.INVOCATION_FAILED;
            }
        }
        if (enabled && this.shaderState != ShaderState.EXTERNAL) {
            BedrockifyClient.LOGGER.info("[{}] The condition matches. BedrockIfy Sun Glare Shading is now disabled.", (Object)Bedrockify.class.getSimpleName());
        }
        return enabled ? ShaderState.EXTERNAL : ShaderState.VANILLA;
    }

    public void tick(float tickDelta) {
        if (!this.shouldApplyShading()) {
            return;
        }
        if (this.client == null || this.client.field_1687 == null) {
            return;
        }
        if (this.client.method_1493()) {
            return;
        }
        float skyAngleRadian = (float)((double)(this.client.field_1687.method_30274(tickDelta) * 2.0f) * java.lang.Math.PI);
        this.sunVector3f.set((Vector3fc)new Vector3f(-Math.sin((float)skyAngleRadian), Math.cos((float)skyAngleRadian), 0.0f).normalize());
    }

    private void updateAngleDiff() {
        if (this.client == null || this.client.field_1687 == null || this.client.field_1773 == null || !this.shouldApplyShading()) {
            this.sunAngleDiff = 1.0f;
            return;
        }
        if (this.client.method_1493()) {
            return;
        }
        float sunSetRiseFactor = this.sunVector3f.y < 0.0f ? this.sunVector3f.y * -5.0f : 0.0f;
        class_4184 camera = this.client.field_1773.method_19418();
        Vector3f cameraVec3f = new Vector3f(0.0f, 0.0f, -1.0f).rotate((Quaternionfc)camera.method_23767()).normalize();
        this.sunAngleDiff = Math.clamp((float)0.0f, (float)1.0f, (float)((Math.safeAcos((float)cameraVec3f.dot((Vector3fc)this.sunVector3f)) - 0.15f) * 2.0f + sunSetRiseFactor));
    }

    public void updateSunBrightnessDelta(float tickProgress) {
        if (class_310.method_1551().field_1687 == null) {
            return;
        }
        float rainGradient = class_310.method_1551().field_1687.method_8430(tickProgress);
        if (class_3532.method_15347((float)rainGradient, (float)1.0f) || !this.shouldApplyShading()) {
            this.sunBrightnessDelta = 1.0f;
            return;
        }
        this.updateAngleDiff();
        this.sunBrightnessDelta = Math.clamp((float)0.0f, (float)1.0f, (float)(this.sunAngleDiff + rainGradient));
    }

    public float getSunBrightnessDelta() {
        return this.sunBrightnessDelta;
    }

    public float getSunIntensityDelta() {
        return this.sunIntensityDelta;
    }

    public void onSunlightIntensityChanged() {
        this.sunIntensityDelta = Math.clamp((float)0.0f, (float)1.0f, (float)((float)BedrockifyClient.getInstance().settings.sunlightIntensity / 100.0f));
    }

    private static enum ShaderState {
        UNSPECIFIED,
        VANILLA,
        EXTERNAL,
        INVOCATION_FAILED;

    }

    private static class ClassMethodHolder {
        public final String canonicalName;
        public final String methodName;
        @NotNull
        public final Object[] methodArgs;
        @NotNull
        public final Predicate<Object> condition;
        public static final ClassMethodHolder CONDITION_TRUE = new ClassMethodHolder("", "", null, object -> true);

        protected ClassMethodHolder(String cName, String mName, @NotNull Object[] mArgs, @NotNull Predicate<Object> condition) {
            this.canonicalName = cName;
            this.methodName = mName;
            this.methodArgs = mArgs;
            this.condition = condition;
        }
    }
}

