/*
 * Decompiled with CFR 0.152.
 */
package me.juancarloscp52.bedrockify.mixin.client.features.chat;

import java.util.List;
import me.juancarloscp52.bedrockify.client.BedrockifyClient;
import me.juancarloscp52.bedrockify.client.BedrockifyClientSettings;
import net.minecraft.class_303;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_338;
import net.minecraft.class_3532;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyArgs;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.invoke.arg.Args;

@Mixin(value={class_338.class})
public abstract class ChatHudMixin {
    @Shadow
    @Final
    private List<class_303.class_7590> field_2064;
    @Shadow
    @Final
    private class_310 field_2062;
    @Shadow
    private int field_2066;
    @Unique
    private float bottomY;
    @Unique
    BedrockifyClientSettings settings;
    @Unique
    private static final String DRAW_CONTEXT_FILL_METHOD_SIGNATURE = "Lnet/minecraft/client/gui/DrawContext;fill(IIIII)V";

    public ChatHudMixin() {
        this.settings = BedrockifyClient.getInstance().settings;
    }

    @Shadow
    protected abstract boolean method_1819();

    @Shadow
    public abstract double method_1814();

    @Shadow
    public abstract int method_1813();

    @Shadow
    protected abstract int method_44752();

    @Unique
    private int bedrockify$getSafeArea() {
        return this.settings.overlayIgnoresSafeArea ? 0 : this.settings.getScreenSafeArea();
    }

    @Unique
    private int bedrockify$applyHudOpacity(int color) {
        if (this.method_1819()) {
            return color;
        }
        float opacity = BedrockifyClient.getInstance().hudOpacity.getHudOpacity(false);
        if (class_3532.method_15347((float)opacity, (float)1.0f)) {
            return color;
        }
        int rgb = color & 0xFFFFFF;
        int alpha = color >> 24 & 0xFF;
        int targetAlpha = Math.max(4, (int)(opacity * (float)alpha));
        return rgb | targetAlpha << 24;
    }

    @Unique
    private int bedrockify$calcChatHudTopOffset() {
        int safeArea = this.bedrockify$getSafeArea();
        return this.settings.getPositionHUDHeight() + (this.settings.getPositionHUDHeight() < 50 ? 50 : 0) + (this.settings.isShowPositionHUDEnabled() ? 10 : 0) + (this.settings.getFPSHUDoption() == 2 ? 10 : 0) + safeArea - 6;
    }

    @Inject(method={"getVisibleLineCount"}, at={@At(value="RETURN")}, cancellable=true)
    private void bedrockify$modifyLineCount(CallbackInfoReturnable<Integer> cir) {
        if (!this.settings.isBedrockChatEnabled() || this.field_2062.field_1705.method_53531().method_53536()) {
            return;
        }
        int original = (Integer)cir.getReturnValue();
        int height = this.field_2062.method_22683().method_4502() - this.bedrockify$calcChatHudTopOffset();
        int lines = class_3532.method_15386((float)((float)height / (float)this.method_44752())) - 3;
        cir.setReturnValue((Object)Math.min(original, lines));
    }

    @Inject(method={"render"}, at={@At(value="HEAD")})
    private void bedrockify$gatherInfo(class_332 context, int currentTick, int mouseX, int mouseY, boolean focused, CallbackInfo ci) {
        if (!this.settings.isBedrockChatEnabled() || this.field_2062.field_1705.method_53531().method_53536()) {
            return;
        }
        int notifications = 0;
        for (class_303.class_7590 line : this.field_2064) {
            if (currentTick - line.comp_895() >= 200) continue;
            ++notifications;
        }
        int visibleLines = this.method_1813();
        int shownLines = this.method_1819() ? Math.min(visibleLines, this.field_2064.size() - this.field_2066) : Math.min(visibleLines, notifications);
        double shownHeight = (double)(shownLines * this.method_44752()) * this.method_1814();
        this.bottomY = (float)((double)(48 - this.field_2062.method_22683().method_4502()) + shownHeight) + (float)this.bedrockify$calcChatHudTopOffset();
    }

    @ModifyArgs(method={"render"}, at=@At(value="INVOKE", target="Lorg/joml/Matrix3x2fStack;translate(FF)Lorg/joml/Matrix3x2f;", ordinal=0))
    private void bedrockify$moveChatHud(Args args) {
        args.set(0, (Object)Float.valueOf(((Float)args.get(0)).floatValue() + (float)this.bedrockify$getSafeArea()));
        if (this.settings.isBedrockChatEnabled() && !this.field_2062.field_1705.method_53531().method_53536()) {
            args.set(1, (Object)Float.valueOf(this.bottomY));
        }
    }

    @ModifyArg(method={"render"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/DrawContext;fill(IIIII)V", ordinal=0), index=4)
    private int bedrockify$modifyMsgBackgroundOpacity(int color) {
        return this.bedrockify$applyHudOpacity(color);
    }

    @ModifyArg(method={"render"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/DrawContext;fill(IIIII)V", ordinal=1), index=4)
    private int bedrockify$modifyIndicatorOpacity(int color) {
        return this.bedrockify$applyHudOpacity(color);
    }

    @ModifyArg(method={"method_71991"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/DrawContext;drawTextWithShadow(Lnet/minecraft/client/font/TextRenderer;Lnet/minecraft/text/OrderedText;III)V", ordinal=0), index=4)
    private int bedrockify$modifyRenderTextOpacity(int color) {
        return this.bedrockify$applyHudOpacity(color);
    }

    @ModifyArg(method={"render"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/DrawContext;drawTextWithShadow(Lnet/minecraft/client/font/TextRenderer;Lnet/minecraft/text/Text;III)V", ordinal=0), index=4)
    private int bedrockify$modifyMsgQueueOpacity(int color) {
        return this.bedrockify$applyHudOpacity(color);
    }

    @Inject(method={"toChatLineY"}, at={@At(value="RETURN")}, cancellable=true)
    private void bedrockify$calcChatLineY(double mouseY, CallbackInfoReturnable<Double> cir) {
        if (!this.settings.isBedrockChatEnabled() || this.field_2062.field_1705.method_53531().method_53536()) {
            return;
        }
        int topY = this.bedrockify$calcChatHudTopOffset();
        int lines = Math.min(this.method_1813(), this.field_2064.size() - this.field_2066) + 1;
        double position = (double)(topY + lines * this.method_44752()) - mouseY - 1.0;
        cir.setReturnValue((Object)(position / (this.method_1814() * (double)this.method_44752())));
    }

    @Inject(method={"toChatLineX"}, at={@At(value="RETURN")}, cancellable=true)
    private void bedrockify$calcChatLineX(double mouseX, CallbackInfoReturnable<Double> cir) {
        double original = (Double)cir.getReturnValue();
        cir.setReturnValue((Object)(original - (double)this.bedrockify$getSafeArea()));
    }
}

