package me.juancarloscp52.bedrockify.client.features.heldItemTooltips;

import com.google.common.collect.Lists;
import me.juancarloscp52.bedrockify.client.BedrockifyClient;
import me.juancarloscp52.bedrockify.client.BedrockifyClientSettings;
import me.juancarloscp52.bedrockify.client.features.heldItemTooltips.tooltip.ContainerTooltip;
import me.juancarloscp52.bedrockify.client.features.heldItemTooltips.tooltip.EnchantmentTooltip;
import me.juancarloscp52.bedrockify.client.features.heldItemTooltips.tooltip.PotionTooltip;
import me.juancarloscp52.bedrockify.client.features.heldItemTooltips.tooltip.Tooltip;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_1291;
import net.minecraft.class_1292;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1812;
import net.minecraft.class_1833;
import net.minecraft.class_1844;
import net.minecraft.class_1890;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import net.minecraft.class_6880;
import net.minecraft.class_746;
import net.minecraft.class_9334;
import net.minecraft.item.*;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class HeldItemTooltips {

    private static final int TOOLTIP_SIZE = 6;

    private static final boolean B_DAB_LOADED = FabricLoader.getInstance().isModLoaded("detailab");

    public void drawItemWithCustomTooltips(class_332 drawContext, class_327 fontRenderer, class_2561 text, float x, float y, int color, class_1799 currentStack) {
        final BedrockifyClientSettings settings = BedrockifyClient.getInstance().settings;
        final int screenBorder = settings.getScreenSafeArea();
        int tooltipOffset = 0;

        //Set tooltip position depending on hotbar displayed information
        class_746 player = class_310.method_1551().field_1724;
        if(null ==player || null==class_310.method_1551().field_1761)
            return;
        if(class_310.method_1551().field_1761.method_2908()){
            y-=16;
            if(player.method_6096()>0 || (B_DAB_LOADED && class_1661.field_56551.keySet().intStream().anyMatch(value -> player.method_31548().method_5438(value).method_57826(class_9334.field_54197)))){
                y-=10;
            }
            if(player.method_6067()>0){
                y-=10;
            }
        }else if((player.method_5854()!=null && player.method_5854() instanceof class_1309)){
            y-=16;
        }

        // Draw item tooltips if the option is enabled.
        if(settings.heldItemTooltips) {
            // Get the current held item tooltips and convert to Text.
            final List<class_2561> tooltips = Lists.newArrayList();
            for (Tooltip tooltip : getTooltips(currentStack)) {
                tooltips.add(tooltip.getTooltipText());
            }
            // Limit the maximum number of shown tooltips to tooltipSize.
            final boolean showMoreTooltip = (tooltips.size() > TOOLTIP_SIZE);
            if (showMoreTooltip) {
                // Store the number of items.
                final int xMore = tooltips.size() - (TOOLTIP_SIZE -1);
                // Trim tooltips.
                tooltips.subList(TOOLTIP_SIZE - 1, tooltips.size()).clear();
                // Add the "and x more..." tooltip.
                tooltips.add(class_2561.method_43469("item.container.more_items", xMore).method_27692(class_124.field_1080));
            }

            tooltipOffset = 12 * tooltips.size();
            //Render background behind tooltip.
            int maxLength = getMaxTooltipLength(tooltips,fontRenderer,currentStack);
            renderBackground(drawContext, y, screenBorder, tooltipOffset, maxLength, color >> 24 & 0xff);


            int i = tooltips.size() - 1;
            for (class_2561 elem : tooltips) {
                // Render the tooltip.
                renderTooltip(drawContext, fontRenderer, y - screenBorder - (12 * i), color, ((class_5250)elem).method_27692(class_124.field_1080));
                --i;
            }
        }

        // Render the item name.
        drawContext.method_27535(fontRenderer, text, (int)x, (int)(y - tooltipOffset - screenBorder), color);
    }

    /**
     * Gets a List with the given item tooltips.
     * @param currentStack Current item stack of the player.
     * @return List with the tooltip information.
     */
    public static List<Tooltip> getTooltips(class_1799 currentStack) {
        final class_1792 item = currentStack.method_7909();
        final List<Tooltip> result = Lists.newArrayList();
        if (item == class_1802.field_8598 || currentStack.method_7942()) {
            var enchantmentsComponent = class_1890.method_57532(currentStack);
            enchantmentsComponent.method_57534().forEach(enchantment -> result.add(new EnchantmentTooltip(enchantment.comp_349(), enchantmentsComponent.method_57536(enchantment))));

        } else if (item instanceof class_1812 || item instanceof class_1833) {
            result.addAll(generateTooltipsForPotion(currentStack));

        } else if (item == class_1802.field_50140) {
            var ominousComponent = currentStack.method_57353().method_58694(class_9334.field_50238);
            if (ominousComponent != null) {
                List<class_1293> list = List.of(new class_1293(class_1294.field_16595, 120000, ominousComponent.comp_3090(), false, false, true));
                result.addAll(generateTooltipsForPotion(currentStack, list));
            }

        } else if(currentStack.method_57353().method_57832(class_9334.field_49622)){
            var container = currentStack.method_58694(class_9334.field_49622);
            if(container != null){
                generateTooltipsFromContainer(container.method_57489().toList(), result);
            }

        } else if (currentStack.method_57353().method_57832(class_9334.field_49650)){
            var container = currentStack.method_57353().method_58694(class_9334.field_49650);
            if(container != null){
                generateTooltipsFromContainer(container.method_59707().toList(), result);
            }
        }

        return result;
    }

    /**
     * Checks if the tooltips of two items are equal.
     */
    public boolean equals(class_1799 item1, class_1799 item2){
        List<Tooltip> itemTooltips1 = getTooltips(item1);
        List<Tooltip> itemTooltips2 = getTooltips(item2);
        // Overriding Object#equals in the class Tooltip allows the use of utility classes provided by Java.
        return Objects.equals(itemTooltips1, itemTooltips2);
    }

    private static void generateTooltipsFromContainer(List<class_1799> items, List<Tooltip> instance){
        for(class_1799 item : items){
            if(!item.method_7960())
                instance.add(new ContainerTooltip(item));
        }
    }

    private static List<PotionTooltip> generateTooltipsForPotion(class_1799 stack, Iterable<class_1293> effects){
        List<PotionTooltip> tooltips = new ArrayList<>();
        for (class_1293 statusEffectInstance : effects) {
            class_6880<class_1291> registryEntry = statusEffectInstance.method_5579();
            int i = statusEffectInstance.method_5578();
            class_5250 mutableText = class_1844.method_66698(registryEntry, i);
            if (!statusEffectInstance.method_48557(20)) {
                mutableText = class_2561.method_43469("potion.withDuration", mutableText, class_1292.method_5577(statusEffectInstance, stack.method_57353().method_58695(class_9334.field_55879, 1.0F), class_310.method_1551().field_1687.method_54719().method_54748()));
            }

            tooltips.add(new PotionTooltip(mutableText.method_27692(registryEntry.comp_349().method_18792().method_18793())));
        }

        if (tooltips.isEmpty()) {
            tooltips.add(new PotionTooltip(class_2561.method_43471("effect.none")));
        }
        return tooltips;
    }

    private static List<PotionTooltip> generateTooltipsForPotion(class_1799 stack) {
        return generateTooltipsForPotion(stack, stack.method_58694(class_9334.field_49651).method_57397());
    }

    private void renderBackground(class_332 drawContext, float y, int screenBorder, int tooltipOffset, int maxLength, int alpha) {
        class_310 client = class_310.method_1551();
        int background = class_3532.method_48781(alpha / 255f, 0, class_3532.method_15384((255.0D * BedrockifyClient.getInstance().settings.heldItemTooltipBackground))) << 24;
        drawContext.method_25294(class_3532.method_15386((client.method_22683().method_4486()-maxLength)/2f-3),class_3532.method_15386(y - tooltipOffset -5- screenBorder), class_3532.method_15386((client.method_22683().method_4486()+maxLength)/2f+1),class_3532.method_15386(y - tooltipOffset -4- screenBorder),background);
        drawContext.method_25294(class_3532.method_15386((client.method_22683().method_4486()-maxLength)/2f-3),class_3532.method_15386(y+12-screenBorder), class_3532.method_15386((client.method_22683().method_4486()+maxLength)/2f+1),class_3532.method_15386(y+13-screenBorder),background);
        drawContext.method_25294(class_3532.method_15386((client.method_22683().method_4486()-maxLength)/2f-4), class_3532.method_15386(y - tooltipOffset -4- screenBorder),class_3532.method_15386((client.method_22683().method_4486()+maxLength)/2f+2), class_3532.method_15386(y+12-screenBorder),background);
    }

    /**
     * Renders an item tooltip with the given text and height in screen.
     */
    private void renderTooltip(class_332 drawContext, class_327 fontRenderer, float y, int color, class_2561 text) {
        int enchantX = (class_310.method_1551().method_22683().method_4486() - fontRenderer.method_27525(text)) / 2;
        drawContext.method_27535(fontRenderer, text, enchantX, (int)y, color);
    }

    private int getMaxTooltipLength(List<class_2561> tooltips, class_327 textRenderer, class_1799 itemStack){
        int maxLength=textRenderer.method_27525(itemStack.method_7964());
        for(class_2561 elem : tooltips){
            int tipLength = textRenderer.method_27525(elem);
            if(maxLength<tipLength)
                maxLength=tipLength;
        }
        return maxLength;
    }
}
