package me.juancarloscp52.bedrockify.client.features.loadingScreens;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.class_10799;
import net.minecraft.class_1132;
import net.minecraft.class_1934;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_5481;
import net.minecraft.class_8020;
import net.minecraft.class_9848;


public class LoadingScreenWidget {

    private static LoadingScreenWidget instance = null;
    private class_1934 gameMode = class_1934.field_9215;
    private static final int TIPS_NUM = 108 +1;
    private static final int CREATIVE_TIPS_NUM = 23 +1;
    private final class_2960 WIDGET_TEXTURE = class_2960.method_60655("bedrockify", "textures/gui/bedrockify_widgets.png");
    private class_2561 tip;
    private static final Set<Integer> EXCLUDED_TIPS = Sets.newHashSet();
    private long lastTipUpdate = 0;
    private final ExternalLoadingTips externalLoadingTips;
    private final class_8020 logoDrawer;

    private LoadingScreenWidget() {
        externalLoadingTips = ExternalLoadingTips.loadSettings();
        externalLoadingTips.saveSettings();
        logoDrawer = new class_8020(false);
    }

    public static LoadingScreenWidget getInstance() {
        if (instance == null) {
            instance = new LoadingScreenWidget();
        }
        return instance;
    }

    /**
     * Retrieve a loading screen tip. This tip will change every 6 seconds.
     * @return Text with the current tip.
     */
    private class_2561 getTip() {
        // Check if gamemode has changed. Force new tooltip if gamemode has changed.
        if(hasChangedGameMode())
            tip = null;

        if (tip == null || System.currentTimeMillis() - lastTipUpdate > 6000) {
            Random randomGenerator = new Random();
            class_1132 server = class_310.method_1551().method_1576();
            if(server !=null && server.method_3790() == class_1934.field_9220){
                tip = class_2561.method_43471("bedrockify.loadingTips.creative." + randomGenerator.nextInt(1,CREATIVE_TIPS_NUM));
            }
            else {
                int externalTipsLength = externalLoadingTips.length();
                int random = randomGenerator.nextInt(1,TIPS_NUM + 1 + externalTipsLength);
                if(externalTipsLength>0 && (random>TIPS_NUM || externalLoadingTips.alwaysExternalTips )){
                    tip = class_2561.method_43470(externalLoadingTips.get(randomGenerator.nextInt(externalTipsLength)));
                }else{
                    if(EXCLUDED_TIPS.contains(random))
                        return getTip();

                    tip = class_2561.method_43471("bedrockify.loadingTips." + random);
                }
            }
            lastTipUpdate = System.currentTimeMillis();
        }
        return tip;
    }

    private boolean hasChangedGameMode(){
        class_1934 current = getCurrentGameMode();
        if(gameMode != current){
            gameMode = current;
            return true;
        }
        return false;
    }

    private class_1934 getCurrentGameMode(){
        class_1132 server = class_310.method_1551().method_1576();
        return server == null? class_1934.field_9215 : server.method_3790();
    }

    /**
     * Renders the bedrockify loading screen.
     * @param drawContext Current draw context.
     * @param width window width
     * @param height window height
     * @param title Title of the loading screen.
     * @param message Message of the loading screen. Set to null to use a random tip.
     * @param progress Loading screen progress. Set to -1 is the screen has no progress bar.
     */
    public void render(class_332 drawContext, int width, int height, class_2561 title, class_2561 message, int progress) {
        class_310 client = class_310.method_1551();

        logoDrawer.method_48210(drawContext,client.method_22683().method_4486(),1,(height/2) - (89 / 2));
        renderLoadingWidget(drawContext, width, height);

        class_327 textRenderer = class_310.method_1551().field_1772;
        drawContext.method_51439(textRenderer, title, width - textRenderer.method_27525(title) / 2, height - 9 / 2 - 32, class_9848.method_61334(76 | (76 << 8) | (76 << 16)),false);
        renderTextBody(drawContext, width, height, message, textRenderer);

        if (progress >= 0) {
            renderLoadingBar(drawContext, width, height, progress);
        }
    }

    private void renderLoadingWidget(class_332 drawContext, int x, int y) {
        drawContext.method_25290(class_10799.field_56883, WIDGET_TEXTURE, x - 256 / 2, y - 89 / 2, 0, 0, 256, 89, 256, 256);
    }


    private void renderTextBody(class_332 drawContext, int x, int y, class_2561 message, class_327 textRenderer) {
        if (message == null)
            message = getTip();
        List<class_5481> text = textRenderer.method_1728(message, 230);
        int maxLineWidth = getMaxLineWidth(textRenderer, text);
        for (int i = 0; i < 4 && i < text.size(); i++) {
            drawContext.method_51430(textRenderer, text.get(i), x - maxLineWidth / 2, y - 15 + (i * 9), -1,false);
        }

    }

    private int getMaxLineWidth(class_327 textRenderer, List<class_5481> text) {
        int maxLineWidth = 0;
        for (int i = 0; i < 4 && i < text.size(); i++) {
            int lineWidth = textRenderer.method_30880(text.get(i));
            if (lineWidth > maxLineWidth)
                maxLineWidth = lineWidth;
        }
        return maxLineWidth;
    }


    private void renderLoadingBar(class_332 drawContext, int x, int y, int progress) {
        int barProgress = (int) ((class_3532.method_15340(progress,0,100)/100.0f) * 223.0f);
        drawContext.method_25290(class_10799.field_56883, WIDGET_TEXTURE, x - 111, y + 26, 0, 89, 222, 5, 256, 256);
        if (barProgress > 0)
            drawContext.method_25290(class_10799.field_56883, WIDGET_TEXTURE, x - 111, y + 26, 0, 94, barProgress, 5, 256, 256);
    }

}
