package me.juancarloscp52.bedrockify.client.features.paperDoll;

import me.juancarloscp52.bedrockify.client.BedrockifyClient;
import me.juancarloscp52.bedrockify.client.BedrockifyClientSettings;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4050;
import net.minecraft.class_481;
import net.minecraft.class_490;
import net.minecraft.class_746;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.spongepowered.include.com.google.common.collect.Sets;

import java.util.Set;

public class PaperDoll {
    private final class_310 client;
    private final int size = 20;
    private long lastTimeShown = 0;
    private final BedrockifyClientSettings settings = BedrockifyClient.getInstance().settings;

    private static final Set<String> TARGET_POSE_NAMES = Sets.newHashSet(class_4050.field_18077.name(), class_4050.field_18079.name(), "CRAWLING");
    private static final float SCREEN_PIXEL_TO_GL_SCALE = 0.0625f;

    public PaperDoll(class_310 client) {
        this.client = client;
    }

    /**
     * Render the player at the top left of the screen.
     * The player will be rendered only when the player is not riding another entity, and it is sneaking, running, using elytra, using an item, underwater, or using a shield.
     */
    public void renderPaperDoll(class_332 drawContext) {
        if (!settings.isShowPaperDollEnabled())
            return;

        if (this.client.field_1755 instanceof class_490 || this.client.field_1755 instanceof class_481) {
            return;
        }

        if (client.field_1724 != null) {
            //If the player does an action that must show the player entity gui, set the counter to the current time.
            if (shouldShow(client.field_1724))
                lastTimeShown = System.currentTimeMillis();

            // If the difference between the current game ticks and showTicks is less than 100 ticks, draw the player entity.
            if ((!client.field_1724.method_3144() && !client.field_1724.method_6113() && System.currentTimeMillis() - lastTimeShown < 2000))
                drawPaperDoll(drawContext);
        }
    }

    /**
     * Checks player's action.
     *
     * @param player An instance of a {@link class_746}.
     * @return {@code true} if condition matches.
     */
    private static boolean shouldShow(class_746 player) {
        return player.method_5715() ||
                player.method_5624() ||
                player.method_5869() ||
                player.method_31549().field_7479 ||  // flying in Creative mode
                player.method_6039() ||
                player.method_6115() ||
                TARGET_POSE_NAMES.contains(player.method_18376().name());
    }

    /**
     * Draw the player entity in the specified position on screen.
     */
    private void drawPaperDoll(class_332 drawContext) {
        class_746 player = client.field_1724;
        if (player == null)
            return;

        // Position the entity on screen.
        int posX = 10;
        int offsetX = -7;
        int renderBottomPosY;
        int offsetY = 2;

        // Determine the position of the doll depending on the position of the overlay text.
        int textPosY = settings.getPositionHUDHeight();
        if (textPosY >= 2 * size + 10) {
            renderBottomPosY = textPosY;
        } else {
            renderBottomPosY = textPosY + size * 2 + 5;
            if (settings.getFPSHUDoption()==2)
                renderBottomPosY += 10;
            if (settings.isShowPositionHUDEnabled())
                renderBottomPosY += 10;
        }

        // If the player is elytra flying, the entity must be manually centered depending on the pitch.
        if (player.method_18376().equals(class_4050.field_18077)) {
            posX = 0;
            offsetY = 15 - class_3532.method_15386(size * 2 * toMaxAngleRatio(player.method_36455()));
        }
        // If the player is swimming, the entity must also be centered in the Y axis.
        else if (player.method_5681()) {
            offsetY = -2;
        }
        int safeArea = settings.overlayIgnoresSafeArea? 0 : settings.getScreenSafeArea();
        int x1 = posX + safeArea;
        int y2 = renderBottomPosY + safeArea;
        int x2 = x1 + class_3532.method_15386(size * 3.25f);
        int y1 = Math.max(safeArea,  y2 - size * 3);
        drawContext.method_44379(x1, y1, x2, y2);

        // Store previous entity rotations.
        float bodyYaw = player.field_6283;
        float yaw = player.method_36454();
        float headYaw = player.field_6241;


        // Set the entity desired rotation for drawing.
        float angle = 145;
        if (player.method_18376().equals(class_4050.field_18077) || player.method_6039()) {
            player.field_6241 = angle;
        } else {
            player.method_36456(headYaw - bodyYaw + angle);
            player.field_6241 = player.method_36454();
        }
        player.field_6283 = angle;

        Vector3f translation = new Vector3f(offsetX * SCREEN_PIXEL_TO_GL_SCALE, player.method_17682() * 0.5f + offsetY * SCREEN_PIXEL_TO_GL_SCALE, 0.0F);
        Quaternionf rotation = new Quaternionf().rotateZ((float)Math.PI);

        // Draw the entity.
        class_490.method_48472(drawContext, x1, y1, x2, y2, this.size / player.method_55693(), translation, rotation, null, player);

        // Restore previous entity rotations.
        player.field_6283 = bodyYaw;
        player.method_36456(yaw);
        player.field_6241 = headYaw;

        drawContext.method_44380();
    }

    private float toMaxAngleRatio(float angle) {
        return (90 + angle) / 180;
    }

}
