package me.juancarloscp52.bedrockify.client.features.reacharoundPlacement;

import me.juancarloscp52.bedrockify.client.BedrockifyClient;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;

import java.util.Optional;

public class ReachAroundPlacement {
    private final class_310 client;

    public ReachAroundPlacement(class_310 client) {
        this.client = client;
    }

    public void renderIndicator(class_332 drawContext) {
        if (BedrockifyClient.getInstance().settings.isReacharoundIndicatorEnabled() && BedrockifyClient.getInstance().settings.isReacharoundEnabled() && (client.method_1542() || BedrockifyClient.getInstance().settings.isReacharoundMultiplayerEnabled()) && this.canReachAround() ) {
            drawContext.method_25294((client.method_22683().method_4486() / 2) - 5, (client.method_22683().method_4502() / 2) + 5, (client.method_22683().method_4486() / 2) + 4, (client.method_22683().method_4502() / 2) + 6, (100 << 24) + (255 << 8));
        }
    }

    public boolean canReachAround() {
        if (client.field_1724 == null || client.field_1687 == null || client.field_1765 == null)
            return false;

        // crosshairTarget must be MISS.
        if (!client.field_1765.method_17783().equals(class_239.class_240.field_1333)) {
            return false;
        }

        final class_746 player = client.field_1724;
        final class_2338 targetPos = getFacingSteppingBlockPos(player);

        // Not sneaking and must sneak in settings.
        if (!player.method_5715() && BedrockifyClient.getInstance().settings.isReacharoundSneakingEnabled()) {
            return false;
        }
        // Player may be flying, climbing the ladder or vines, or on the Fluid with sneaking.
        if (!player.method_24828()) {
            return false;
        }
        // There is a non-replaceable block at the ReachAround target position.
        if (!client.field_1687.method_8320(targetPos).method_45474()) {
            return false;
        }

        return getRaycastIntersection(player).isPresent();
    }

    /**
     * Helper method that retrieves Reach-Around block position.
     *
     * @return The position of the block to be placed.
     */
    public static class_2338 getFacingSteppingBlockPos(@NotNull class_1297 player) {
        return player.method_23312().method_10093(player.method_5735());
    }

    /**
     * Draws a vector from the player's eyes to the end of the reach distance, in the direction the player is facing. We can use this to check if the block is valid for placement.
     * @return The position of the intersection between the raycast and the surface of the target block.
     * @author axialeaa
     */
    private Optional<class_243> getRaycastIntersection(@NotNull class_746 player) {
        class_243 rayStartPos = player.method_33571();
        class_243 rayEndPos = player.method_5828(1.0F).method_1021(player.method_55754()).method_1019(rayStartPos);

        return new class_238(getFacingSteppingBlockPos(player)).method_992(rayStartPos, rayEndPos);
    }
}
