package me.juancarloscp52.bedrockify.client.gui;

import me.juancarloscp52.bedrockify.client.BedrockifyClient;
import me.juancarloscp52.bedrockify.client.BedrockifyClientSettings;
import me.juancarloscp52.bedrockify.client.features.paperDoll.PaperDoll;
import me.juancarloscp52.bedrockify.client.features.savingOverlay.SavingOverlay;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import java.util.Objects;

public class Overlay {

    private final class_310 client;
    private final PaperDoll paperDoll;
    public final SavingOverlay savingOverlay;
    private class_2561 fps;
    private final int textPosX = 0;

    public Overlay(class_310 client) {
        this.client = client;
        this.paperDoll = new PaperDoll(client);
        this.savingOverlay = new SavingOverlay();
    }

    public void renderOverlay(class_332 drawContext) {
        // Only render the overlay if HUD is not hidden and debug is NOT enabled.
        if (!client.field_1705.method_53531().method_53536() && !client.field_1690.field_1842){
            this.renderText(drawContext);
            this.paperDoll.renderPaperDoll(drawContext);
            BedrockifyClient.getInstance().reachAroundPlacement.renderIndicator(drawContext);
            this.savingOverlay.render(drawContext);
        }
    }

    /**
     * Renders the text components for the player position and client fps.
     */
    private void renderText(class_332 drawContext) {
        fps = class_2561.method_43471("bedrockify.hud.fps").method_27693(String.valueOf(client.method_47599()));
        renderPositionText(drawContext);
        renderFpsText(drawContext);
    }

    private void renderPositionText(class_332 drawContext) {
        BedrockifyClientSettings settings = BedrockifyClient.getInstance().settings;
        int screenBorder = settings.overlayIgnoresSafeArea ? 0 : settings.getScreenSafeArea();
        int posY = settings.getPositionHUDHeight();
        if (!settings.isShowPositionHUDEnabled())
            return;
        class_2338 blockPos = Objects.requireNonNull(this.client.method_1560(), "Camera Entity cannot be null.").method_24515();
        class_5250 position = class_2561.method_43471("bedrockify.hud.position").method_10852(class_2561.method_43470(" "+ blockPos.method_10263() + ", " + blockPos.method_10264() + ", " + blockPos.method_10260()));
        if(settings.getFPSHUDoption()==1)
            position.method_27693(" ").method_10852(fps);
        int positionWidth = client.field_1772.method_27525(position);
        float opacity = BedrockifyClient.getInstance().hudOpacity.getHudOpacity(false);
//        RenderSystem.setShaderColor(1,1,1,1);
        drawContext.method_25294(textPosX + screenBorder, posY + screenBorder, textPosX + positionWidth + 6 + screenBorder, posY + 12 + screenBorder, class_3532.method_15384((255.0D * client.field_1690.method_42550().method_41753()) * opacity)<<24);
        int alpha = (int) Math.ceil(opacity*255);
        drawContext.method_27535(client.field_1772, position, textPosX + 3 + screenBorder, posY + 3 + screenBorder, 16777215 | ((alpha) << 24));
    }

    private void renderFpsText(class_332 drawContext) {
        BedrockifyClientSettings settings = BedrockifyClient.getInstance().settings;
        int screenBorder = settings.overlayIgnoresSafeArea ? 0 : settings.getScreenSafeArea();
        int posY = settings.getPositionHUDHeight()+2;
        boolean positionEnabled = settings.isShowPositionHUDEnabled();
        if (settings.getFPSHUDoption()!=2)
            return;
        int fpsCounterWidth = client.field_1772.method_27525(fps);
        float opacity = BedrockifyClient.getInstance().hudOpacity.getHudOpacity(false);
//        RenderSystem.setShaderColor(1,1,1,1);
        drawContext.method_25294(textPosX + screenBorder, posY + (positionEnabled ? 10 : 0) + screenBorder, textPosX + fpsCounterWidth + 6 + screenBorder, posY + (positionEnabled ? 10 : 0) + 10 + screenBorder, class_3532.method_15384((255.0D * client.field_1690.method_42550().method_41753()) * opacity)<<24);
        int alpha = (int) Math.ceil(opacity*255);
        drawContext.method_27535(client.field_1772, fps, textPosX + 3 + screenBorder, posY + 1 + (positionEnabled ? 10 : 0) + screenBorder, 16777215 | ((alpha) << 24));
    }

}
