package me.juancarloscp52.bedrockify.client.gui;

import me.juancarloscp52.bedrockify.Bedrockify;
import me.juancarloscp52.bedrockify.BedrockifySettings;
import me.juancarloscp52.bedrockify.client.BedrockifyClient;
import me.juancarloscp52.bedrockify.client.BedrockifyClientSettings;
import me.juancarloscp52.bedrockify.mixin.featureManager.MixinFeatureManager;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.impl.builders.SubCategoryBuilder;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import java.util.List;
import java.util.Map;

public class SettingsGUI {

    BedrockifyClientSettings settingsClient = BedrockifyClient.getInstance().settings;
    BedrockifySettings settingsCommon = Bedrockify.getInstance().settings;

    public class_437 getConfigScreen(class_437 parent){
        ConfigBuilder builder = ConfigBuilder.create().setParentScreen(parent).setTitle(class_2561.method_43471("bedrockify.options.settings"));
        builder.setSavingRunnable(()-> {
            Bedrockify.getInstance().saveSettings();
            BedrockifyClient.getInstance().saveSettings();
            MixinFeatureManager.saveMixinSettings();
        });

        builder.setDefaultBackgroundTexture(class_2960.method_60654("minecraft:textures/block/bedrock.png"));
        // Create Categories
        ConfigCategory gameplay = builder.getOrCreateCategory(class_2561.method_43471("bedrockify.options.categories.gameplay"));
        ConfigCategory gui = builder.getOrCreateCategory(class_2561.method_43471("bedrockify.options.categories.gui"));
        ConfigCategory visualImprovements = builder.getOrCreateCategory(class_2561.method_43471("bedrockify.options.categories.visualImprovements"));
        ConfigCategory mixins = builder.getOrCreateCategory(class_2561.method_43471("bedrockify.options.categories.mixins"));

        ConfigEntryBuilder entryBuilder = builder.entryBuilder();

        /*
        *
        *   Gameplay Category
        *
        */

            // Reach Around Placement Sub Category
            SubCategoryBuilder reachAround = entryBuilder.startSubCategory(class_2561.method_43471("bedrockify.options.subCategory.Reach-Around"));
            reachAround.add(entryBuilder.startTextDescription(class_2561.method_43471("bedrockify.options.subCategory.Reach-Around.description")).build());
            reachAround.add(entryBuilder.startBooleanToggle(class_2561.method_43471("bedrockify.options.reachAround"), settingsClient.reacharound).setDefaultValue(true).setSaveConsumer(newValue -> settingsClient.reacharound=newValue).build());
            reachAround.add(entryBuilder.startBooleanToggle(class_2561.method_43471("bedrockify.options.reachAround.multiplayer"), settingsClient.reacharoundMultiplayer).setDefaultValue(true).setSaveConsumer(newValue -> settingsClient.reacharoundMultiplayer=newValue).build());
            reachAround.add(entryBuilder.startBooleanToggle(class_2561.method_43471("bedrockify.options.reachAround.sneaking"), settingsClient.reacharoundSneaking).setDefaultValue(false).setSaveConsumer(newValue -> settingsClient.reacharoundSneaking=newValue).build());
            reachAround.add(entryBuilder.startBooleanToggle(class_2561.method_43471("bedrockify.options.reachAround.indicator"), settingsClient.reacharoundIndicator).setDefaultValue(false).setSaveConsumer(newValue -> settingsClient.reacharoundIndicator=newValue).build());
            gameplay.addEntry(reachAround.build());
        
            // Dying Trees.
            gameplay.addEntry(entryBuilder.startBooleanToggle(class_2561.method_43471("bedrockify.options.dyingTrees"), settingsCommon.dyingTrees).setDefaultValue(true).setSaveConsumer(newValue -> settingsCommon.dyingTrees=newValue).build());

            // Other Settings.
            gameplay.addEntry(entryBuilder.startBooleanToggle(class_2561.method_43471("bedrockify.options.recipes"), settingsCommon.bedrockRecipes).setTooltip(wrapLines(class_2561.method_43471("bedrockify.options.recipes.tooltip"))).setDefaultValue(true).setSaveConsumer(newValue -> settingsCommon.bedrockRecipes=newValue).build());
            gameplay.addEntry(entryBuilder.startBooleanToggle(class_2561.method_43471("bedrockify.options.fireAspectLight"), settingsCommon.fireAspectLight).setTooltip(wrapLines(class_2561.method_43471("bedrockify.options.fireAspectLight.tooltip"))).setDefaultValue(true).setSaveConsumer(newValue -> settingsCommon.fireAspectLight=newValue).build());
            gameplay.addEntry(entryBuilder.startBooleanToggle(class_2561.method_43471("bedrockify.options.fernBonemeal"), settingsCommon.fernBonemeal).setDefaultValue(true).setSaveConsumer(newValue -> settingsCommon.fernBonemeal=newValue).build());
            gameplay.addEntry(entryBuilder.startBooleanToggle(class_2561.method_43471("bedrockify.options.disableFlyingMomentum"), settingsClient.disableFlyingMomentum).setDefaultValue(true).setSaveConsumer(newValue -> settingsClient.disableFlyingMomentum =newValue).build());
            gameplay.addEntry(entryBuilder.startBooleanToggle(class_2561.method_43471("bedrockify.options.elytraStop"), settingsClient.elytraStop).setDefaultValue(true).setSaveConsumer(newValue -> settingsClient.elytraStop=newValue).build());
            gameplay.addEntry(entryBuilder.startBooleanToggle(class_2561.method_43471("bedrockify.options.bedrockCauldron"), settingsCommon.bedrockCauldron).setTooltip(wrapLines(class_2561.method_43471("bedrockify.options.bedrockCauldron.tooltip"))).setDefaultValue(true).setSaveConsumer(newValue -> settingsCommon.bedrockCauldron=newValue).build());

        /*
         *
         *   GUI Category
         *
         */
            // Bedrock loading screens.
            gui.addEntry(entryBuilder.startBooleanToggle(class_2561.method_43471("bedrockify.options.loadingScreen"), settingsClient.loadingScreen).setDefaultValue(true).setSaveConsumer(newValue -> settingsClient.loadingScreen=newValue).build());
            gui.addEntry(entryBuilder.startBooleanToggle(class_2561.method_43471("bedrockify.options.loadingScreenChunkMap"), settingsClient.showChunkMap).setTooltip(wrapLines(class_2561.method_43471("bedrockify.options.loadingScreenChunkMap.tooltip"))).setDefaultValue(false).setSaveConsumer(newValue -> settingsClient.showChunkMap=newValue).build());

            // Overlay
            SubCategoryBuilder bedrockOverlay = entryBuilder.startSubCategory(class_2561.method_43471("bedrockify.options.subCategory.bedrockOverlay"));
            bedrockOverlay.add(entryBuilder.startTextDescription(class_2561.method_43471("bedrockify.options.subCategory.bedrockOverlay.description")).build());
            bedrockOverlay.add(entryBuilder.startBooleanToggle(class_2561.method_43471("bedrockify.options.showCoordinates"), settingsClient.showPositionHUD).setDefaultValue(true).setSaveConsumer(newValue -> settingsClient.showPositionHUD=newValue).build());
            bedrockOverlay.add(entryBuilder.startSelector(class_2561.method_43471("bedrockify.options.showFPS"), new Byte []{0,1,2}, settingsClient.FPSHUD).setDefaultValue((byte) 0).setNameProvider((value)-> switch (value) {
                case 0 -> class_2561.method_43471("bedrockify.options.off");
                case 1 -> class_2561.method_43471("bedrockify.options.withPosition");
                default -> class_2561.method_43471("bedrockify.options.underPosition");
            }).setSaveConsumer((newValue)-> settingsClient.FPSHUD=newValue).build());
            bedrockOverlay.add(entryBuilder.startIntSlider(class_2561.method_43471("bedrockify.options.coordinatesPosition"), settingsClient.positionHUDHeight,0,100).setDefaultValue(50).setSaveConsumer((newValue)-> settingsClient.positionHUDHeight=newValue).build());
            bedrockOverlay.add(entryBuilder.startBooleanToggle(class_2561.method_43471("bedrockify.options.showPaperDoll"), settingsClient.showPaperDoll).setDefaultValue(true).setSaveConsumer(newValue -> settingsClient.showPaperDoll=newValue).build());
            bedrockOverlay.add(entryBuilder.startBooleanToggle(class_2561.method_43471("bedrockify.options.showSavingOverlay"), settingsClient.savingOverlay).setDefaultValue(true).setSaveConsumer(newValue -> settingsClient.savingOverlay=newValue).build());
            gui.addEntry(bedrockOverlay.build());

            //Tooltips
            SubCategoryBuilder tooltips = entryBuilder.startSubCategory(class_2561.method_43471("bedrockify.options.subCategory.tooltips"));
            tooltips.add(entryBuilder.startBooleanToggle(class_2561.method_43471("bedrockify.options.tooltips"), settingsClient.heldItemTooltips).setDefaultValue(true).setSaveConsumer(newValue -> settingsClient.heldItemTooltips =newValue).build());
            tooltips.add(entryBuilder.startIntSlider(class_2561.method_43471("bedrockify.options.tooltips.background"),(int)Math.ceil(settingsClient.heldItemTooltipBackground*100),0,100).setDefaultValue(50).setSaveConsumer(newValue -> settingsClient.heldItemTooltipBackground=newValue/100d).build());
            gui.addEntry(tooltips.build());

            //Item slot Highlight
            SubCategoryBuilder itemHighlight = entryBuilder.startSubCategory(class_2561.method_43471("bedrockify.options.subCategory.inventoryHighlight"));
            itemHighlight.add(entryBuilder.startBooleanToggle(class_2561.method_43471("bedrockify.options.inventoryHighlight"), settingsClient.slotHighlight).setDefaultValue(true).setSaveConsumer(newValue -> settingsClient.slotHighlight=newValue).build());
            itemHighlight.add(entryBuilder.startAlphaColorField(class_2561.method_43471("bedrockify.options.inventoryHighlight.color1"), settingsClient.highLightColor1).setDefaultValue(0xffffffff).setSaveConsumer(newValue -> settingsClient.highLightColor1=newValue).build());
            itemHighlight.add(entryBuilder.startAlphaColorField(class_2561.method_43471("bedrockify.options.inventoryHighlight.color2"), settingsClient.highLightColor2).setDefaultValue(0x8955ba00).setSaveConsumer(newValue -> settingsClient.highLightColor2=newValue).build());
            gui.addEntry(itemHighlight.build());

            // Screen Safe Area
            SubCategoryBuilder screenSafeArea = entryBuilder.startSubCategory(class_2561.method_43471("bedrockify.options.subCategory.screenSafeArea"));
            screenSafeArea.add(entryBuilder.startIntSlider(class_2561.method_43471("bedrockify.options.screenSafeArea"), settingsClient.screenSafeArea,0,30).setDefaultValue(2).setSaveConsumer((newValue)-> settingsClient.screenSafeArea=newValue).build());
            screenSafeArea.add(entryBuilder.startBooleanToggle(class_2561.method_43471("bedrockify.options.HotBarOverhang"), settingsClient.hotBarOverhang).setDefaultValue(true).setSaveConsumer(newValue -> settingsClient.hotBarOverhang = newValue).build());
            screenSafeArea.add(entryBuilder.startBooleanToggle(class_2561.method_43471("bedrockify.options.ignoreBorder"), settingsClient.overlayIgnoresSafeArea).setDefaultValue(false).setSaveConsumer(newValue -> settingsClient.overlayIgnoresSafeArea=newValue).build());
            gui.addEntry(screenSafeArea.build());

            //Other gui improvements.
            gui.addEntry(entryBuilder.startBooleanToggle(class_2561.method_43471("bedrockify.options.biggerItems"), settingsClient.biggerIcons).setDefaultValue(true).setSaveConsumer(newValue -> settingsClient.biggerIcons=newValue).build());
            gui.addEntry(entryBuilder.startBooleanToggle(class_2561.method_43471("bedrockify.options.toolbarStyle"), settingsClient.bedrockToolbar).setDefaultValue(true).setSaveConsumer(newValue -> settingsClient.bedrockToolbar =newValue).setYesNoTextSupplier((value)->value ? class_2561.method_43471("bedrockify.options.chatStyle.bedrock") : class_2561.method_43471("bedrockify.options.chatStyle.vanilla")).setTooltip(wrapLines(class_2561.method_43471("bedrockify.options.toolbarStyle.tooltip"))).build());
            gui.addEntry(entryBuilder.startBooleanToggle(class_2561.method_43471("bedrockify.options.expTextStyle"), settingsClient.expTextStyle).setDefaultValue(true).setSaveConsumer(newValue -> settingsClient.expTextStyle=newValue).setYesNoTextSupplier((value)->value ? class_2561.method_43471("bedrockify.options.chatStyle.bedrock") : class_2561.method_43471("bedrockify.options.chatStyle.vanilla")).build());
            gui.addEntry(entryBuilder.startBooleanToggle(class_2561.method_43471("bedrockify.options.chatStyle"), settingsClient.bedrockChat).setDefaultValue(true).setSaveConsumer(newValue -> settingsClient.bedrockChat=newValue).setYesNoTextSupplier((value)->value ? class_2561.method_43471("bedrockify.options.chatStyle.bedrock") : class_2561.method_43471("bedrockify.options.chatStyle.vanilla")).build());
            gui.addEntry(entryBuilder.startBooleanToggle(class_2561.method_43471("bedrockify.options.pickupAnimations"), settingsClient.pickupAnimations).setTooltip(wrapLines(class_2561.method_43471("bedrockify.options.pickupAnimations.tooltip"))).setDefaultValue(true).setSaveConsumer(newValue -> settingsClient.pickupAnimations=newValue).build());
            gui.addEntry(entryBuilder.startIntSlider(class_2561.method_43471("bedrockify.options.hudOpacity"), settingsClient.hudOpacity,0,100).setDefaultValue(50).setSaveConsumer((newValue)-> {
                settingsClient.hudOpacity = newValue;
                BedrockifyClient.getInstance().hudOpacity.resetTicks();
            }).build());
            gui.addEntry(entryBuilder.startEnumSelector(class_2561.method_43471("bedrockify.options.showBedrockIfyButton"), BedrockifyClientSettings.ButtonPosition.class, settingsClient.bedrockIfyButtonPosition).setTooltip(wrapLines(class_2561.method_43471("bedrockify.options.showBedrockIfyButton.tooltip"))).setEnumNameProvider(anEnum -> class_2561.method_43471(((BedrockifyClientSettings.ButtonPosition)anEnum).text)).setDefaultValue(BedrockifyClientSettings.ButtonPosition.BELOW_SLIDERS).setSaveConsumer(buttonPosition -> settingsClient.bedrockIfyButtonPosition =buttonPosition).build());
            gui.addEntry(entryBuilder.startBooleanToggle(class_2561.method_43471("bedrockify.options.editionBranding"), settingsClient.hideEditionBranding).setDefaultValue(false).setSaveConsumer(newValue -> settingsClient.hideEditionBranding =newValue).build());


        /*
         *
         *   Visual Improvements Category
         *
         */
            visualImprovements.addEntry(entryBuilder.startBooleanToggle(class_2561.method_43471("bedrockify.options.fishingBobber3D"), settingsClient.fishingBobber3D).setDefaultValue(true).setSaveConsumer(newValue -> settingsClient.fishingBobber3D=newValue).build());
            visualImprovements.addEntry(entryBuilder.startBooleanToggle(class_2561.method_43471("bedrockify.options.babyVillagerHeads"), settingsClient.babyVillagerHeads).setDefaultValue(true).setSaveConsumer(newValue -> settingsClient.babyVillagerHeads=newValue).build());
            visualImprovements.addEntry(entryBuilder.startSelector(class_2561.method_43471("bedrockify.options.idleAnimation"), new Float []{0.0f,0.5f,1.0f,1.5f,2.0f,2.5f,3.0f,4.0f}, settingsClient.idleAnimation).setDefaultValue(1.0f).setNameProvider((value)-> class_2561.method_43470("x"+ value)).setSaveConsumer((newValue)-> settingsClient.idleAnimation=newValue).build());
            visualImprovements.addEntry(entryBuilder.startBooleanToggle(class_2561.method_43471("bedrockify.options.eatingAnimations"), settingsClient.eatingAnimations).setDefaultValue(true).setSaveConsumer(newValue -> settingsClient.eatingAnimations=newValue).build());
            visualImprovements.addEntry(entryBuilder.startBooleanToggle(class_2561.method_43471("bedrockify.options.bedrockShading"), settingsClient.bedrockShading).setTooltip(wrapLines(class_2561.method_43471("bedrockify.options.bedrockShading.tooltip"))).setDefaultValue(true).setSaveConsumer(newValue -> {
                settingsClient.bedrockShading=newValue;
                class_310.method_1551().field_1769.method_3279();
            }).build());
            visualImprovements.addEntry(entryBuilder.startIntSlider(class_2561.method_43471("bedrockify.options.sunlightIntensity"), settingsClient.sunlightIntensity,0,100).setTooltip(wrapLines(class_2561.method_43471("bedrockify.options.sunlightIntensity.tooltip"))).setDefaultValue(50).setSaveConsumer(newValue -> {
                settingsClient.sunlightIntensity = newValue;
                BedrockifyClient.getInstance().bedrockSunGlareShading.onSunlightIntensityChanged();
            }).build());

        /*
         *
         *   Mixins Category
         *
         */
            mixins.addEntry(entryBuilder.startTextDescription(class_2561.method_43471("bedrockify.options.mixins.description")).build());
            for(Map.Entry<String, Boolean> elem : MixinFeatureManager.features.entrySet()){
                mixins.addEntry(entryBuilder.startBooleanToggle(class_2561.method_43471(elem.getKey()), elem.getValue()).setDefaultValue(true).setSaveConsumer(newValue -> MixinFeatureManager.features.put(elem.getKey(),newValue)).build());
            }



        return builder.setTransparentBackground(true).build();
    }

    public class_2561[] wrapLines(class_2561 text){
        List<class_5348> lines = class_310.method_1551().field_1772.method_27527().method_27495(text,Math.max(class_310.method_1551().method_22683().method_4486()/2 - 43,170), class_2583.field_24360);
        lines.getFirst().getString();
        class_2561[] textLines = new class_2561[lines.size()];
        for (int i = 0; i < lines.size(); i++) {
            textLines[i]=class_2561.method_43470(lines.get(i).getString());
        }
        return textLines;
    }

}
