package me.juancarloscp52.bedrockify.common.block;

import com.mojang.serialization.MapCodec;
import me.juancarloscp52.bedrockify.Bedrockify;
import me.juancarloscp52.bedrockify.common.block.cauldron.BedrockCauldronBehavior;
import me.juancarloscp52.bedrockify.common.features.cauldron.BedrockCauldronProperties;
import net.minecraft.block.*;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2275;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2758;
import net.minecraft.class_3532;
import net.minecraft.class_5556;
import net.minecraft.class_5712;

/**
 * Allows to dye using Cauldron.<br>
 * Dye items for which {@link net.minecraft.item.DyeableItem} is implemented.
 */
public class ColoredWaterCauldronBlock extends AbstractBECauldronBlock {
    public static final MapCodec<ColoredWaterCauldronBlock> CODEC = ColoredWaterCauldronBlock.method_54094(ColoredWaterCauldronBlock::new);

    public static final class_2758 LEVEL = BedrockCauldronProperties.LEVEL_6;
    public static final int MAX_LEVEL = BedrockCauldronProperties.MAX_LEVEL_6;

    private static final int BOTTLE_LEVEL = MAX_LEVEL / class_5556.field_31108;

    public ColoredWaterCauldronBlock(class_2251 settings) {
        super(settings, BedrockCauldronBehavior.COLORED_WATER_CAULDRON_BEHAVIOR);
        this.method_9590(this.method_9595().method_11664().method_11657(LEVEL, BOTTLE_LEVEL));
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(LEVEL);
    }

    @Override
    public boolean method_32766(class_2680 state) {
        return state.method_11654(LEVEL) == MAX_LEVEL;
    }

    @Override
    public int method_9572(class_2680 state, class_1937 world, class_2338 pos, class_2350 direction) {
        return (int) Math.ceil((float) state.method_11654(LEVEL) / MAX_LEVEL * class_5556.field_31108);
    }

    @Override
    protected MapCodec<? extends class_2275> method_53969() {
        return field_46280;
    }

    @Override
    public double method_31615(class_2680 state) {
        return class_3532.method_16436((float) state.method_11654(LEVEL) / MAX_LEVEL, 0.375, 0.9375);
    }

    public static void decrementWhenDye(class_2680 state, class_1937 world, class_2338 pos) {
        final int decremented = state.method_11654(LEVEL) - 1;
        final class_2680 newState = (decremented == 0) ? class_2246.field_10593.method_9564() : state.method_11657(LEVEL, decremented);
        world.method_8501(pos, newState);
        world.method_43276(class_5712.field_28733, pos, class_5712.class_7397.method_43287(newState));
    }

    public static int getLevelFromWaterCauldronState(class_2680 state) {
        if (!state.method_28498(class_5556.field_27206)) {
            Bedrockify.LOGGER.error(
                    "[%s] state conversion failed".formatted(Bedrockify.class.getSimpleName()),
                    new IllegalStateException("BlockState of %s does not have state: %s".formatted(state.method_26204(), class_5556.field_27206)));
            return 0;
        }

        return class_3532.method_48781((float) state.method_11654(class_5556.field_27206) / class_5556.field_31108, 0, MAX_LEVEL);
    }

    public static int convertToWaterCauldronLevel(class_2680 state) {
        if (!state.method_28498(LEVEL)) {
            Bedrockify.LOGGER.error(
                    "[%s] state conversion failed".formatted(Bedrockify.class.getSimpleName()),
                    new IllegalStateException("BlockState of %s does not have state: %s".formatted(state.method_26204(), LEVEL)));
            return 0;
        }

        return (int) Math.floor((float) state.method_11654(LEVEL) / MAX_LEVEL * class_5556.field_31108);
    }

    public static boolean tryPickFluid(class_2680 state, class_1937 world, class_2338 pos) {
        final int nextLevel = state.method_11654(LEVEL) - BOTTLE_LEVEL;
        if (nextLevel < 0) {
            return false;
        }
        class_2680 blockState = (nextLevel == 0) ? class_2246.field_10593.method_9564() : state.method_11657(LEVEL, nextLevel);
        world.method_8501(pos, blockState);
        world.method_43276(class_5712.field_28733, pos, class_5712.class_7397.method_43287(blockState));
        return true;
    }
}
