package me.juancarloscp52.bedrockify.common.block.entity;

import me.juancarloscp52.bedrockify.Bedrockify;
import me.juancarloscp52.bedrockify.common.block.ColoredWaterCauldronBlock;
import me.juancarloscp52.bedrockify.common.features.cauldron.BedrockCauldronBlocks;
import me.juancarloscp52.bedrockify.common.features.cauldron.ColorBlenderHelper;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1844;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

import java.util.Objects;

/**
 * Allows to keep Dyes and Potions.
 */
public class WaterCauldronBlockEntity extends class_2586 {
    public static final String KEY_FLUID_TINT = "tint_color";
    public static final String KEY_FLUID_ITEM = "item_id";
    public static final String KEY_POTION_TYPE = "potion_type";

    private static final int COLOR_WHEN_ERROR = 0xff000000;

    private int tintColor;
    private class_2960 fluidId;
    private class_2960 potionTypeId;

    public WaterCauldronBlockEntity(class_2338 pos, class_2680 state) {
        super(BedrockCauldronBlocks.WATER_CAULDRON_ENTITY, pos, state);
    }

    public int getTintColor() {
        return this.tintColor;
    }

    @Nullable
    public class_2960 getFluidId() {
        return this.fluidId;
    }

    public class_1792 getPotionType() {
        class_1792 item = class_7923.field_41178.method_63535(this.potionTypeId);
        if (Objects.equals(class_7923.field_41178.method_10221(item), class_7923.field_41178.method_10137())) {
            item = class_1802.field_8574;
        }
        return item;
    }

    public void setPotion(class_1799 potionItem) {
        final var component = potionItem.method_58694(class_9334.field_49651);
        if (component == null) {
            return;
        }
        var optionalPotion = component.comp_2378();
        if (optionalPotion.isEmpty()) {
            return;
        }
        var potion = optionalPotion.get();
        this.potionTypeId = class_7923.field_41178.method_10221(potionItem.method_7909());
        this.fluidId = class_7923.field_41179.method_10221(potion.comp_349());
        this.setTintColor(component.method_8064());
    }

    public void setDyeColor(int itemColor) {
        final int resultColor;
        if (Objects.equals(this.fluidId, class_7923.field_41175.method_10221(BedrockCauldronBlocks.COLORED_WATER_CAULDRON))) {
            resultColor = ColorBlenderHelper.blendColors(this.getTintColor(), itemColor);
        } else {
            this.fluidId = class_7923.field_41175.method_10221(BedrockCauldronBlocks.COLORED_WATER_CAULDRON);
            resultColor = itemColor;
        }
        this.setTintColor(resultColor);
    }

    private void setTintColor(int tintColor) {
        this.tintColor = tintColor;
        this.method_5431();
        this.updateListeners();
    }

    /**
     * Defines the validity of the ID used for {@link WaterCauldronBlockEntity#fluidId}.
     */
    private void checkExactIds() {
        boolean valid = false;
        // These branches could be simpler, but please do not simplify them.
        // Reason: To maintain forward compatibility from Bedrockify v1.7
        // Check commit e37f57564d736d455e4a06dcdce259ea0be377de
        if (class_7923.field_41178.method_63535(this.getFluidId()) instanceof class_1769 dyeItem) {
            this.setDyeColor(ColorBlenderHelper.fromDyeItem(dyeItem));
            valid = true;
        } else if (class_7923.field_41175.method_63535(this.getFluidId()) instanceof ColoredWaterCauldronBlock) {
            valid = true;
        } else {
            var potionEntry = class_7923.field_41179.method_10223(this.getFluidId());
            if (potionEntry.isPresent()) {
                valid = true;
                this.setTintColor(Objects.requireNonNull(class_1844.method_57400(class_1802.field_8469, potionEntry.get()).method_58694(class_9334.field_49651)).method_8064());
            }
        }
        if (!valid) {
            this.setTintColor(COLOR_WHEN_ERROR);
        }
    }

    private void updateListeners() {
        if (this.field_11863 != null) {
            this.field_11863.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), class_2248.field_31028);
        }
    }

    @Nullable
    private static class_2960 getIdFromDataView(class_11368 view, String key) {
        try {
            final String id = view.method_71428(key, "");
            return id.isEmpty() ? null : class_2960.method_12829(id);
        } catch (Exception ex) {
            Bedrockify.LOGGER.error("getIdFromDataView(): Error when parsing identifier: key = {}", key);
        }
        return null;
    }

    @Override
    protected void method_11014(class_11368 view) {
        super.method_11014(view);

        this.tintColor = view.method_71424(KEY_FLUID_TINT, COLOR_WHEN_ERROR);
        this.fluidId = getIdFromDataView(view, KEY_FLUID_ITEM);
        this.potionTypeId = getIdFromDataView(view, KEY_POTION_TYPE);
        this.checkExactIds();
        this.updateListeners();
    }

    @Override
    protected void method_11007(class_11372 view) {
        view.method_71465(KEY_FLUID_TINT, this.tintColor);
        view.method_71469(KEY_FLUID_ITEM, (this.fluidId == null) ? "<NULL>" : this.fluidId.toString());
        view.method_71469(KEY_POTION_TYPE, (this.potionTypeId == null) ? "<NULL>" : this.potionTypeId.toString());

        super.method_11007(view);
    }

    @Nullable
    @Override
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585(this);
    }

    @Override
    public class_2487 method_16887(class_7225.class_7874 registryLookup) {
        return method_38244(registryLookup);
    }
}
