package me.juancarloscp52.bedrockify.common.features.cauldron;

import java.util.Arrays;
import java.util.List;
import net.minecraft.class_1769;
import net.minecraft.class_1799;
import net.minecraft.class_3489;
import net.minecraft.class_9282;
import net.minecraft.class_9334;

/**
 * Used by {@link me.juancarloscp52.bedrockify.common.block.ColoredWaterCauldronBlock}.
 */
public final class ColorBlenderHelper {
    private ColorBlenderHelper() {
    }

    /**
     * The mostly same as {@link class_9282#method_57471(class_1799, List)}.<br>
     * Blend the color, and set it as the {@link class_1799} color.
     *
     * @param base   The base stack of DyeableItem.
     * @param colors Target colors to mix.
     * @return Blended item stack.
     */
    public static class_1799 blendColors(class_1799 base, int... colors) {
        if (!base.method_31573(class_3489.field_48803)) {
            return base;
        }
        class_9282 dyedColorComponent = base.method_58694(class_9334.field_49644);

        final int[] blendArray;
        if (dyedColorComponent != null) {
            blendArray = Arrays.copyOf(colors, colors.length + 1);
            blendArray[blendArray.length - 1] = class_9282.method_57470(base, 0xFFA06540);
        } else {
            blendArray = colors;
        }

        base.method_57379(class_9334.field_49644, new class_9282(blendColors(blendArray)));
        return base;
    }

    /**
     * This logic is based on {@link class_9282#method_57471(class_1799, List)}.
     *
     * @param blender Target colors to mix.
     * @return The blended color.
     */
    public static int blendColors(int... blender) {
        int peekComponent = 0;
        int count = 0;
        int[] blended = new int[3];

        for (int color : blender) {
            final int red = color >> 16 & 255;
            final int green = color >> 8 & 255;
            final int blue = color & 255;
            peekComponent += Math.max(red, Math.max(green, blue));
            blended[0] += red;
            blended[1] += green;
            blended[2] += blue;
            ++count;
        }

        final int normalizedRed = blended[0] / count;
        final int normalizedGreen = blended[1] / count;
        final int normalizedBlue = blended[2] / count;
        final float peekMul = (float) peekComponent / count;
        int peek = Math.max(normalizedRed, Math.max(normalizedGreen, normalizedBlue));
        final int resultRed = (int) (normalizedRed * peekMul / peek);
        final int resultGreen = (int) (normalizedGreen * peekMul / peek);
        final int resultBlue = (int) (normalizedBlue * peekMul / peek);

        return resultRed << 16 | resultGreen << 8 | resultBlue;
    }

    public static int fromDyeItem(class_1769 item) {
        return item.method_7802().method_7787();
    }
}
