package me.juancarloscp52.bedrockify.common.features.worldGeneration;

import com.google.common.collect.Maps;
import me.juancarloscp52.bedrockify.Bedrockify;
import net.fabricmc.fabric.api.biome.v1.*;
import net.minecraft.class_156;
import net.minecraft.class_1972;
import net.minecraft.class_2893;
import net.minecraft.class_2960;
import net.minecraft.class_2975;
import net.minecraft.class_4663;
import net.minecraft.class_5321;
import net.minecraft.class_6796;
import net.minecraft.class_7924;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class DyingTrees {

    public static final class_4663<FullTrunkVineTreeDecorator> VINE_DECORATOR = class_4663.method_28895("bedrockify:vinedecorator", FullTrunkVineTreeDecorator.CODEC);

    public static final class_5321<class_2975<?, ?>> DYING_OAK_TREE = class_5321.method_29179(class_7924.field_41239, class_2960.method_60655("bedrockify", "dying_oak_tree"));
    public static final class_5321<class_2975<?, ?>> DYING_BIRCH_TREE = class_5321.method_29179(class_7924.field_41239, class_2960.method_60655("bedrockify", "dying_birch_tree"));
    public static final class_5321<class_2975<?, ?>> DYING_SPRUCE_TREE = class_5321.method_29179(class_7924.field_41239, class_2960.method_60655("bedrockify", "dying_spruce_tree"));
    public static final class_5321<class_2975<?, ?>> DYING_PINE_TREE = class_5321.method_29179(class_7924.field_41239, class_2960.method_60655("bedrockify", "dying_pine_tree"));
    public static final class_5321<class_2975<?, ?>> DYING_DARK_OAK_TREE = class_5321.method_29179(class_7924.field_41239, class_2960.method_60655("bedrockify", "dying_dark_oak_tree"));


    public static final class_5321<class_6796> DYING_BIRCH_TREE_PF = class_5321.method_29179(class_7924.field_41245, class_2960.method_60655("bedrockify", "dying_birch_tree"));
    public static final class_5321<class_6796> DYING_OAK_TREE_PF = class_5321.method_29179(class_7924.field_41245, class_2960.method_60655("bedrockify", "dying_oak_tree"));
    public static final class_5321<class_6796> DYING_OAK_TREE_PLAINS_PF = class_5321.method_29179(class_7924.field_41245, class_2960.method_60655("bedrockify", "dying_oak_tree_plains"));
    public static final class_5321<class_6796> DYING_SPRUCE_TREE_PF = class_5321.method_29179(class_7924.field_41245, class_2960.method_60655("bedrockify", "dying_spruce_tree"));
    public static final class_5321<class_6796> DYING_PINE_TREE_PF = class_5321.method_29179(class_7924.field_41245, class_2960.method_60655("bedrockify", "dying_pine_tree"));
    public static final class_5321<class_6796> DYING_DARK_OAK_TREE_PF = class_5321.method_29179(class_7924.field_41245, class_2960.method_60655("bedrockify", "dying_dark_oak_tree"));

    private static final Predicate<BiomeSelectionContext> BIRCH_BIOME_SELECTION_CONTEXT = BiomeSelectors.includeByKey(class_1972.field_9409,class_1972.field_9412,class_1972.field_9475,class_1972.field_9414, class_1972.field_35112);
    private static final Predicate<BiomeSelectionContext> OAK_BIOME_SELECTION_CONTEXT = BiomeSelectors.includeByKey(class_1972.field_9409,class_1972.field_9414, class_1972.field_9475,class_1972.field_35120);
    private static final Predicate<BiomeSelectionContext> OAK_PLAINS_BIOME_SELECTION_CONTEXT = BiomeSelectors.includeByKey(class_1972.field_9451,class_1972.field_9455);
    private static final Predicate<BiomeSelectionContext> SPRUCE_BIOME_SELECTION_CONTEXT = BiomeSelectors.includeByKey(class_1972.field_35113,class_1972.field_35119, class_1972.field_9420,class_1972.field_35120,class_1972.field_9420);
    private static final Predicate<BiomeSelectionContext> DARK_OAK_BIOME_SELECTION_CONTEXT = BiomeSelectors.includeByKey(class_1972.field_9475);

    /**
     * Register modifiers for dying tree<br>
     * BiomeModification -&gt; BiomeDecorator
     *
     * @see BiomeModification
     * @see DyingTrees.BiomeDecorator
     */
    private static final Map<BiomeModification, BiomeDecorator> DYING_TREE_DECORATORS = class_156.method_654(Maps.newHashMap(), map -> {
        map.put(
                BiomeModifications.create(class_2960.method_60654("bedrockify:dyingtrees_birch")),
                new BiomeDecorator(BIRCH_BIOME_SELECTION_CONTEXT, DYING_BIRCH_TREE_PF)
        );
        map.put(
                BiomeModifications.create(class_2960.method_60654("bedrockify:dyingtrees_oak")),
                new BiomeDecorator(OAK_BIOME_SELECTION_CONTEXT, DYING_OAK_TREE_PF)
        );
        map.put(
                BiomeModifications.create(class_2960.method_60654("bedrockify:dyingtrees_oak_plains")),
                new BiomeDecorator(OAK_PLAINS_BIOME_SELECTION_CONTEXT, DYING_OAK_TREE_PLAINS_PF)
        );
        map.put(
                BiomeModifications.create(class_2960.method_60654("bedrockify:dyingtrees_spruce")),
                new BiomeDecorator(SPRUCE_BIOME_SELECTION_CONTEXT, DYING_SPRUCE_TREE_PF, DYING_PINE_TREE_PF)
        );
        map.put(
                BiomeModifications.create(class_2960.method_60654("bedrockify:dyingtrees_dark_oak")),
                new BiomeDecorator(DARK_OAK_BIOME_SELECTION_CONTEXT, DYING_DARK_OAK_TREE_PF)
        );
    });

    /**
     * A data only class that records BiomeSelectionContext and List of PlacedFeature
     *
     * @see BiomeSelectionContext
     * @see class_6796
     */
    private static final class BiomeDecorator {
        public final Predicate<BiomeSelectionContext> selector;
        public final List<class_5321<class_6796>> features;

        @SafeVarargs
        public BiomeDecorator(Predicate<BiomeSelectionContext> selector, class_5321<class_6796>... features) {
            this.selector = selector;
            this.features = Arrays.stream(features).filter(Objects::nonNull).toList();
        }
    }

    public static void registerTrees(){
        registerDyingTrees();
    }

    private static void registerDyingTrees (){
        DYING_TREE_DECORATORS.forEach((modification, decorator) -> {
            modification.add(ModificationPhase.ADDITIONS, decorator.selector, biomeModificationContext -> {
                if (Bedrockify.getInstance().settings.dyingTrees) {
                    decorator.features.forEach(feature -> {
                        biomeModificationContext.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, feature);
                    });
                } else {
                    decorator.features.forEach(feature -> {
                        biomeModificationContext.getGenerationSettings().removeFeature(class_2893.class_2895.field_13178, feature);
                    });
                }
            });
        });
    }

}
