package me.juancarloscp52.bedrockify.datagen;

import com.google.common.collect.ImmutableList;
import me.juancarloscp52.bedrockify.common.features.fernBonemeal.FernBonemeal;
import me.juancarloscp52.bedrockify.common.features.worldGeneration.DyingTrees;
import me.juancarloscp52.bedrockify.common.features.worldGeneration.FullTrunkVineTreeDecorator;
import me.juancarloscp52.bedrockify.mixin.common.features.worldGeneration.TreeConfiguredFeaturesInvoker;
import net.minecraft.class_2246;
import net.minecraft.class_2975;
import net.minecraft.class_3031;
import net.minecraft.class_3175;
import net.minecraft.class_4643;
import net.minecraft.class_4649;
import net.minecraft.class_4650;
import net.minecraft.class_4651;
import net.minecraft.class_5140;
import net.minecraft.class_5203;
import net.minecraft.class_5204;
import net.minecraft.class_5206;
import net.minecraft.class_5211;
import net.minecraft.class_6016;
import net.minecraft.class_6019;
import net.minecraft.class_6796;
import net.minecraft.class_6817;
import net.minecraft.class_6819;
import net.minecraft.class_7871;
import net.minecraft.class_7891;
import net.minecraft.class_7924;
import net.minecraft.world.gen.feature.*;
import java.util.Collections;
import java.util.OptionalInt;

public class BedrockIfyWorldGenBootstrap {

    // Create tree configured features
    private static final class_2975<?, ?> DYING_BIRCH_TREE_CONFIGURED = new class_2975<>(class_3031.field_24134, TreeConfiguredFeaturesInvoker.invokeBuilder(class_2246.field_10511, class_2246.field_10539, 5, 2, 0, 2).method_27374().method_27376(ImmutableList.of(FullTrunkVineTreeDecorator.INSTANCE)).method_23445());
    static final class_2975<?,?> DYING_OAK_TREE_CONFIGURED = new class_2975<>(class_3031.field_24134, TreeConfiguredFeaturesInvoker.invokeBuilder(class_2246.field_10431, class_2246.field_10503, 4, 2, 0, 2).method_27374().method_27376(ImmutableList.of(FullTrunkVineTreeDecorator.INSTANCE)).method_23445());
    private static final class_2975<?, ?> DYING_SPRUCE_TREE_CONFIGURED =  new class_2975<>(class_3031.field_24134, new class_4643.class_4644(class_4651.method_38432(class_2246.field_10037), new class_5140(5, 2, 1), class_4651.method_38432(class_2246.field_9988), new class_4650(class_6019.method_35017(2, 3), class_6019.method_35017(0, 2), class_6019.method_35017(1, 2)), new class_5204(2, 0, 2)).method_27374().method_27376(ImmutableList.of(FullTrunkVineTreeDecorator.INSTANCE)).method_23445());
    private static final class_2975<?, ?> DYING_PINE_TREE_CONFIGURED = new class_2975<>(class_3031.field_24134, new class_4643.class_4644(class_4651.method_38432(class_2246.field_10037), new class_5140(6, 4, 0), class_4651.method_38432(class_2246.field_9988), new class_4649(class_6016.method_34998(1), class_6016.method_34998(1), class_6019.method_35017(3, 4)), new class_5204(2, 0, 2)).method_27374().method_27376(ImmutableList.of(FullTrunkVineTreeDecorator.INSTANCE)).method_23445());
    private static final class_2975<?, ?> DYING_DARK_OAK_TREE_CONFIGURED = new class_2975<>(class_3031.field_24134, new class_4643.class_4644(class_4651.method_38432(class_2246.field_10010), new class_5211(6, 2, 1), class_4651.method_38432(class_2246.field_10035), new class_5206(class_6016.method_34998(0), class_6016.method_34998(0)), new class_5203(1, 1, 0, 1, 2, OptionalInt.empty())).method_27374().method_27376(ImmutableList.of(FullTrunkVineTreeDecorator.INSTANCE)).method_23445());

    // Define tree placed features
    private static class_6796 PLACED_DYING_BIRCH_TREE;
    private static class_6796 PLACED_DYING_OAK_TREE;
    private static class_6796 PLACED_DYING_OAK_TREE_PLAINS;
    private static class_6796 PLACED_DYING_SPRUCE_TREE;
    private static class_6796 PLACED_DYING_PINE_TREE;
    private static class_6796 PLACED_DYING_DARK_OAK_TREE;

    private static final class_2975<class_3175, ?> SINGLE_PIECE_OF_FERN = new class_2975<>(class_3031.field_13518, new class_3175(class_4651.method_38433(class_2246.field_10112.method_9564())));

    private static class_6796 PLACED_FERN_BONEMEAL;


    // Create tree placed features
    private static void initializeTreePlacedFeatures(class_7871<class_2975<?,?>> lookup){
        PLACED_DYING_BIRCH_TREE = new class_6796(lookup.method_46747(DyingTrees.DYING_BIRCH_TREE),class_6819.method_39741(class_6817.method_39736(0, 0.25f, 2), class_2246.field_10575));
        PLACED_DYING_OAK_TREE = new class_6796(lookup.method_46747(DyingTrees.DYING_OAK_TREE),class_6819.method_39741(class_6817.method_39736(1, 0.1f, 0), class_2246.field_10394));
        PLACED_DYING_OAK_TREE_PLAINS = new class_6796(lookup.method_46747(DyingTrees.DYING_OAK_TREE),class_6819.method_39741(class_6817.method_39736(0, 0.01f, 1), class_2246.field_10394));
        PLACED_DYING_SPRUCE_TREE = new class_6796(lookup.method_46747(DyingTrees.DYING_SPRUCE_TREE),class_6819.method_39741(class_6817.method_39736(1, 0.1f, 0), class_2246.field_10217));
        PLACED_DYING_PINE_TREE = new class_6796(lookup.method_46747(DyingTrees.DYING_PINE_TREE),class_6819.method_39741(class_6817.method_39736(1, 0.1f, 0), class_2246.field_10217));
        PLACED_DYING_DARK_OAK_TREE = new class_6796(lookup.method_46747(DyingTrees.DYING_DARK_OAK_TREE),class_6819.method_39741(class_6817.method_39736(1, 0.1f, 0), class_2246.field_10160));

        PLACED_FERN_BONEMEAL = new class_6796(lookup.method_46747(FernBonemeal.SINGLE_PIECE_OF_FERN), Collections.singletonList(class_6817.method_40371()));
    }

    static void placedFeatures(class_7891<class_6796> registry){
        class_7871<class_2975<?,?>> configuredFeatureLookup = registry.method_46799(class_7924.field_41239);
        initializeTreePlacedFeatures(configuredFeatureLookup);

        registry.method_46838(DyingTrees.DYING_BIRCH_TREE_PF,PLACED_DYING_BIRCH_TREE);
        registry.method_46838(DyingTrees.DYING_OAK_TREE_PF,PLACED_DYING_OAK_TREE);
        registry.method_46838(DyingTrees.DYING_OAK_TREE_PLAINS_PF,PLACED_DYING_OAK_TREE_PLAINS);
        registry.method_46838(DyingTrees.DYING_SPRUCE_TREE_PF,PLACED_DYING_SPRUCE_TREE);
        registry.method_46838(DyingTrees.DYING_PINE_TREE_PF,PLACED_DYING_PINE_TREE);
        registry.method_46838(DyingTrees.DYING_DARK_OAK_TREE_PF,PLACED_DYING_DARK_OAK_TREE);

        registry.method_46838(FernBonemeal.SINGLE_PIECE_OF_FERN_PLACED,PLACED_FERN_BONEMEAL);
    }

    public static void configureFeatures(class_7891<class_2975<?, ?>> registry){
        //RegistryEntryLookup<PlacedFeature> placedFeatureLookup = registry.getRegistryLookup(RegistryKeys.PLACED_FEATURE);
        registry.method_46838(DyingTrees.DYING_BIRCH_TREE, DYING_BIRCH_TREE_CONFIGURED);
        registry.method_46838(DyingTrees.DYING_OAK_TREE, DYING_OAK_TREE_CONFIGURED);
        registry.method_46838(DyingTrees.DYING_SPRUCE_TREE, DYING_SPRUCE_TREE_CONFIGURED);
        registry.method_46838(DyingTrees.DYING_PINE_TREE, DYING_PINE_TREE_CONFIGURED);
        registry.method_46838(DyingTrees.DYING_DARK_OAK_TREE, DYING_DARK_OAK_TREE_CONFIGURED);

        registry.method_46838(FernBonemeal.SINGLE_PIECE_OF_FERN,SINGLE_PIECE_OF_FERN);

    }
}
