package me.juancarloscp52.bedrockify.mixin.client.features.bedrockShading.sunGlare;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import me.juancarloscp52.bedrockify.client.BedrockifyClient;
import me.juancarloscp52.bedrockify.client.features.bedrockShading.BedrockSunGlareShading;
import net.minecraft.class_1972;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_638;
import net.minecraft.class_9848;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(class_638.class)
public abstract class ClientWorldMixin {
    @Shadow
    private @Final class_310 client;

    /**
     * Modify the Sky color based on Camera angle.
     *
     * @return modified sky color
     */
    @ModifyReturnValue(method = "getSkyColor", at = @At("RETURN"))
    private int bedrockify$modifySkyColor(int original) {
        final BedrockSunGlareShading sunGlareShading = BedrockifyClient.getInstance().bedrockSunGlareShading;
        if (!sunGlareShading.shouldApplyShading() || this.client.field_1687 == null) {
            return original;
        }

        final float delta = sunGlareShading.getSunBrightnessDelta();
        final float skyAtt = class_3532.method_16439(sunGlareShading.getSunIntensityDelta(), 1f, 0.6f);
        class_243 color = class_243.method_24457(original);

        // Closer to the Sun, Darken the Sky, based on camera angle. Use a different multiplier for each channel in order to better match bedrock edition sky color.
        float multiplierBlue = class_3532.method_16439(delta, skyAtt, 1f);
        float multiplierRed = class_3532.method_16439(delta, skyAtt - 0.16f, 1f);
        float multiplierGreen = class_3532.method_16439(delta, skyAtt - 0.06f, 1f);

        // Use same dimming for all three channels when the biome is PALE GARDEN, with some extra darkness.
        if (client.field_1724!=null && client.field_1687.method_23753(client.field_1724.method_24515()).method_40226(class_1972.field_55052.method_29177())){
            final float darker = class_3532.method_16439(sunGlareShading.getSunIntensityDelta(), 1f, 0.4f);
            multiplierRed = class_3532.method_16439(delta, darker, 1f);
            multiplierGreen = class_3532.method_16439(delta, darker, 1f);
            multiplierBlue = class_3532.method_16439(delta, darker, 1f);
        }

        return class_9848.method_61325(color.method_18805(multiplierRed, multiplierGreen, multiplierBlue));
    }

    @ModifyReturnValue(method = "getCloudsColor", at = @At("RETURN"))
    private int bedrockify$modifyCloudsColor(int original) {
        BedrockSunGlareShading sunGlareShading = BedrockifyClient.getInstance().bedrockSunGlareShading;
        class_243 color = class_243.method_24457(original);
        return class_9848.method_61325(color.method_1021(class_3532.method_15390(0.8d, 1.0d, sunGlareShading.getSunBrightnessDelta())));
    }

}
