package me.juancarloscp52.bedrockify.mixin.client.features.eatingAnimations;

import me.juancarloscp52.bedrockify.client.BedrockifyClient;
import me.juancarloscp52.bedrockify.client.features.eatingAnimations.IEatingState;
import net.minecraft.class_10055;
import net.minecraft.class_1268;
import net.minecraft.class_1306;
import net.minecraft.class_572;
import net.minecraft.class_591;
import net.minecraft.class_630;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_591.class)
public class PlayerEntityModelMixin extends class_572<class_10055> {
    public PlayerEntityModelMixin(class_630 root) {
        super(root);
    }

    @Inject(method = "setAngles", at=@At("TAIL"))
    private void applyEatingAnimation(class_10055 playerEntityRenderState, CallbackInfo info){
        if(!BedrockifyClient.getInstance().settings.isEatingAnimationsEnabled())
            return;

        if (!(playerEntityRenderState instanceof IEatingState state)) {
            return;
        }

        final var eatingHand = state.getEatingHand();
        final class_1306 mainArm = playerEntityRenderState.field_55303;

        eatingHand.ifPresent(hand -> {
            if (hand == class_1268.field_5808) {
                playEatingAnimation(playerEntityRenderState, mainArm);
            } else if (hand == class_1268.field_5810) {
                playEatingAnimation(playerEntityRenderState, mainArm.method_5928());
            }
        });
    }

    @Unique
    private static final float ITEM_START_TIME = 8f/20f; //in second
    @Unique
    private static final float ITEM_INTERVAL_TIME = 4f/20f; //in second

    @Unique
    private void playEatingAnimation(class_10055 state, class_1306 targetArm) {
        final float ticks = BedrockifyClient.getInstance().deltaTime * 0.000000001f;
        final float itemUseTime = state.field_53407;
        float smoothingTicks = false ? (float) (ticks - Math.floor(ticks)) : 0; //if you want to add an option for spothing the anim, it's already here, just replace the false
//        float itemStartProgress = Math.min(livingEntity.getItemUseTime() + smoothingTicks, 20f* ITEM_START_TIME)/20f/ ITEM_START_TIME;
        float itemStartProgress = Math.min(itemUseTime + smoothingTicks, 20f * ITEM_START_TIME) * 0.05f / ITEM_START_TIME;
        float itemIntervalProgress = (itemUseTime * 0.05f < ITEM_START_TIME) ? 0.0f : (((itemUseTime - (int) ITEM_START_TIME *20) % (int) (ITEM_INTERVAL_TIME *20)) + smoothingTicks)* ITEM_INTERVAL_TIME;
        float animPitch = itemStartProgress * -degToMatAngle(60.0f) + itemIntervalProgress * degToMatAngle(11.25f);
        float animYaw = itemStartProgress * -degToMatAngle(22.5f) + itemIntervalProgress * degToMatAngle(11.25f);
        float animRoll = itemStartProgress * -degToMatAngle(5.625f) + itemIntervalProgress * degToMatAngle(11.25f);

        if (targetArm == class_1306.field_6183) {
            this.field_3401.field_3654 += animPitch;
            this.field_3401.field_3675 += animYaw;
            this.field_3401.field_3674 += animRoll;
        } else {
            this.field_27433.field_3654 += animPitch;
            this.field_27433.field_3675 -= animYaw;
            this.field_27433.field_3674 += animRoll;
        }
    }

    @Unique
    private float degToMatAngle(float angle)
    {
//        return 7.07f * angle / 360;
        return 7.07f * angle * 0.002777778f;
    }
}
