package me.juancarloscp52.bedrockify.mixin.client.features.eatingAnimations;

import me.juancarloscp52.bedrockify.client.BedrockifyClient;
import me.juancarloscp52.bedrockify.client.features.eatingAnimations.IEatingState;
import net.minecraft.class_10055;
import net.minecraft.class_1007;
import net.minecraft.class_11890;
import net.minecraft.class_11901;
import net.minecraft.class_1268;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_1007.class)
public abstract class PlayerEntityRendererMixin<AvatarlikeEntity extends class_11890 & class_11901> {
    @Inject(method = "updateRenderState", at = @At("HEAD"))
    private void bedrockify$storeEatingState(AvatarlikeEntity avatarlikeEntity, class_10055 playerEntityRenderState, float f, CallbackInfo ci) {
        if (!BedrockifyClient.getInstance().settings.isEatingAnimationsEnabled() || !(playerEntityRenderState instanceof IEatingState state)) {
            return;
        }

        class_1799 mainHandStack = avatarlikeEntity.method_6047();
        class_1799 offHandStack = avatarlikeEntity.method_6079();
        if (bedrockify$checkEatingAction(avatarlikeEntity, playerEntityRenderState, class_1268.field_5808, mainHandStack)) {
            state.setEatingHand(class_1268.field_5808);
        } else if (bedrockify$checkEatingAction(avatarlikeEntity, playerEntityRenderState, class_1268.field_5810, offHandStack)) {
            state.setEatingHand(class_1268.field_5810);
        } else {
            state.setEatingHand(null);
        }
    }

    @Unique
    private boolean bedrockify$checkEatingAction(AvatarlikeEntity entity, class_10055 state, class_1268 hand, class_1799 itemStack) {
        return entity.method_6115() && state.field_53409 == hand && (itemStack.method_7976() == class_1839.field_8950 || itemStack.method_7976() == class_1839.field_8946);
    }
}
