package me.juancarloscp52.bedrockify.mixin.client.features.heldItemTooltips;

import me.juancarloscp52.bedrockify.client.BedrockifyClient;
import me.juancarloscp52.bedrockify.client.features.heldItemTooltips.HeldItemTooltips;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_329;
import net.minecraft.class_332;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(class_329.class)
public class ItemTooltipsMixin {
    @Shadow private class_1799 currentStack;

    @Shadow private int heldItemTooltipFade;

    @Shadow @Final private class_310 client;

    /**
     * Draw custom tooltips for effects and enchantments before the heldItemTooltip is rendered.
     */
    @Redirect(method = "renderHeldItemTooltip", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/DrawContext;drawTextWithBackground(Lnet/minecraft/client/font/TextRenderer;Lnet/minecraft/text/Text;IIII)V"))
    private void drawCustomTooltips(class_332 instance, class_327 textRenderer, class_2561 text, int x, int y, int width, int color) {
        BedrockifyClient.getInstance().heldItemTooltips.drawItemWithCustomTooltips(instance,textRenderer, text, x, class_310.method_1551().method_22683().method_4502() - 38, color, currentStack);
    }

    /**
     * Show the item tooltip when changing from an item to another of the same type and name IFF different tooltips.
     */
    @Redirect(method = "tick()V", at = @At(value = "INVOKE", target = "Lnet/minecraft/item/ItemStack;isEmpty()Z", ordinal = 1))
    private boolean interceptItemStack(class_1799 itemStack) {
        class_1799 nextItem = this.client.field_1724.method_6047();
        HeldItemTooltips heldItemTooltips = BedrockifyClient.getInstance().heldItemTooltips;
        if(itemStack.method_7909() == this.currentStack.method_7909() && !heldItemTooltips.equals(currentStack,nextItem)){
            this.heldItemTooltipFade = 41;
            return true;
        }

        return currentStack.method_7960();
    }
}
