package me.juancarloscp52.bedrockify.mixin.client.features.hudOpacity;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import me.juancarloscp52.bedrockify.client.BedrockifyClient;
import me.juancarloscp52.bedrockify.client.features.hudOpacity.HudOpacity;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_9848;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value = class_329.class, priority = 500)
public class InGameHudMixin {

    @Unique
    private HudOpacity hudOpacity;
    
    @Inject(method = "<init>", at = @At("RETURN"))
    private void init(class_310 client, CallbackInfo ci){
        hudOpacity = BedrockifyClient.getInstance().hudOpacity;
    }
    
    @WrapOperation(method = "renderHotbar", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/DrawContext;drawGuiTexture(Lcom/mojang/blaze3d/pipeline/RenderPipeline;Lnet/minecraft/util/Identifier;IIII)V"))
    public void setShaderColorOpacity(class_332 context, RenderPipeline pipeline, class_2960 sprite, int x, int y, int width, int height, Operation<Void> original){
        context.method_71501(pipeline, sprite, x, y, width, height, hudOpacity.getHudOpacity(false));
    }

    @WrapOperation(method = "renderHotbar", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/DrawContext;drawGuiTexture(Lcom/mojang/blaze3d/pipeline/RenderPipeline;Lnet/minecraft/util/Identifier;IIIIIIII)V"))
    public void setAttackIconColorOpacity(class_332 instance, RenderPipeline pipeline, class_2960 sprite, int textureWidth, int textureHeight, int u, int v, int x, int y, int width, int height, Operation<Void> original){
        instance.method_52708(pipeline, sprite, textureWidth, textureHeight, u, v, x, y, width, height, class_9848.method_61317(hudOpacity.getHudOpacity(false)));
    }

    //region Status Bars
    @WrapOperation(method = "drawHeart", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/DrawContext;drawGuiTexture(Lcom/mojang/blaze3d/pipeline/RenderPipeline;Lnet/minecraft/util/Identifier;IIII)V"))
    public void setHealthBarColorOpacity(class_332 instance, RenderPipeline pipeline, class_2960 sprite, int x, int y, int width, int height, Operation<Void> original){
        instance.method_52707(pipeline, sprite, x, y, width, height, class_9848.method_61317(hudOpacity.getHudOpacity(false)));
    }

    @WrapOperation(method = "renderArmor", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/DrawContext;drawGuiTexture(Lcom/mojang/blaze3d/pipeline/RenderPipeline;Lnet/minecraft/util/Identifier;IIII)V"))
    private static void setArmorBarColorOpacity(class_332 instance, RenderPipeline pipeline, class_2960 sprite, int x, int y, int width, int height, Operation<Void> original){
        instance.method_52707(pipeline, sprite, x, y, width, height, class_9848.method_61317(BedrockifyClient.getInstance().hudOpacity.getHudOpacity(false)));
    }

    @WrapOperation(method = "renderFood", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/DrawContext;drawGuiTexture(Lcom/mojang/blaze3d/pipeline/RenderPipeline;Lnet/minecraft/util/Identifier;IIII)V"))
    private void setFoodBarColorOpacity(class_332 instance, RenderPipeline pipeline, class_2960 sprite, int x, int y, int width, int height, Operation<Void> original){
        instance.method_52707(pipeline, sprite, x, y, width, height, class_9848.method_61317(hudOpacity.getHudOpacity(false)));
    }

    @WrapOperation(method = "renderAirBubbles", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/DrawContext;drawGuiTexture(Lcom/mojang/blaze3d/pipeline/RenderPipeline;Lnet/minecraft/util/Identifier;IIII)V"))
    private void setAirBarColorOpacity(class_332 instance, RenderPipeline pipeline, class_2960 sprite, int x, int y, int width, int height, Operation<Void> original){
        instance.method_52707(pipeline, sprite, x, y, width, height, class_9848.method_61317(hudOpacity.getHudOpacity(false)));
    }

    @WrapOperation(method = "renderMountHealth", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/DrawContext;drawGuiTexture(Lcom/mojang/blaze3d/pipeline/RenderPipeline;Lnet/minecraft/util/Identifier;IIII)V"))
    private void setMountHealthBarColorOpacity(class_332 instance, RenderPipeline pipeline, class_2960 sprite, int x, int y, int width, int height, Operation<Void> original){
        instance.method_52707(pipeline, sprite, x, y, width, height, class_9848.method_61317(hudOpacity.getHudOpacity(false)));
    }
    //endregion

    //region Status Effects
    @WrapOperation(method = "renderStatusEffectOverlay", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/DrawContext;drawGuiTexture(Lcom/mojang/blaze3d/pipeline/RenderPipeline;Lnet/minecraft/util/Identifier;IIII)V"))
    public void setStatusEffectOpacityHead(class_332 instance, RenderPipeline pipeline, class_2960 sprite, int x, int y, int width, int height, Operation<Void> original){
        instance.method_52707(pipeline, sprite, x, y, width, height, class_9848.method_61317(hudOpacity.getHudOpacity(false)));
    }

    @ModifyConstant(method = "renderStatusEffectOverlay", constant = @Constant(floatValue = 1.f, ordinal = 0))
    public float setOpacityStatusEffectImage (float f){
        return f * hudOpacity.getHudOpacity(false);
    }
    //endregion
}
