package me.juancarloscp52.bedrockify.mixin.client.features.loadingScreens;

import me.juancarloscp52.bedrockify.client.BedrockifyClient;
import me.juancarloscp52.bedrockify.client.features.loadingScreens.LoadingScreenWidget;
import net.minecraft.class_2535;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_412;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_6379;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(class_412.class)
public class ConnectScreenMixin extends class_437 {

    @Shadow class_2535 connection;
    @Shadow boolean connectingCancelled;
    @Shadow @Final class_437 parent;

    protected ConnectScreenMixin(class_2561 title) {
        super(title);
    }

    /**
     * Draws the loading screen widget.
     */
    @Redirect(method = "render", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/DrawContext;drawCenteredTextWithShadow(Lnet/minecraft/client/font/TextRenderer;Lnet/minecraft/text/Text;III)V"))
    public void drawLoadingScreenWidget(class_332 drawContext, class_327 textRenderer, class_2561 text, int x, int y, int color) {
        if(BedrockifyClient.getInstance().settings.isLoadingScreenEnabled()){
            LoadingScreenWidget.getInstance().render(drawContext, class_310.method_1551().method_22683().method_4486() / 2, class_310.method_1551().method_22683().method_4502() / 2, class_2561.method_43470(text.getString()), null, -1);
        }else{
            drawContext.method_27534(textRenderer, text, x, y, color);
        }
    }

    /**
     * Move the cancel bottom down.
     */
    @Redirect(method = "init", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/screen/multiplayer/ConnectScreen;addDrawableChild(Lnet/minecraft/client/gui/Element;)Lnet/minecraft/client/gui/Element;"))
    public <T extends class_364 & class_4068 & class_6379> T addDrawableChild(class_412 connectScreen, T drawableElement) {
        if(BedrockifyClient.getInstance().settings.isLoadingScreenEnabled()){
            return (T) this.method_37063(class_4185.method_46430(class_5244.field_24335, (buttonWidget) -> {
                this.connectingCancelled = true;
                if (this.connection != null) {
                    this.connection.method_10747(class_2561.method_43471("connect.aborted"));
                }
                this.field_22787.method_1507(this.parent);
            }).method_46433(this.field_22789 / 2 - 100, (int) Math.ceil(class_310.method_1551().method_22683().method_4502() * 0.75D)).method_46432(200).method_46431());
        }else{
            return this.method_37063(drawableElement);
        }
    }
}
