package me.juancarloscp52.bedrockify.mixin.client.features.reacharoundPlacement;


import me.juancarloscp52.bedrockify.client.BedrockifyClient;
import me.juancarloscp52.bedrockify.client.features.reacharoundPlacement.ReachAroundPlacement;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_4093;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;


@Mixin(class_310.class)
public abstract class MinecraftClientMixin extends class_4093<Runnable> {
    @Shadow
    public class_746 player;
    @Shadow
    @Nullable
    public class_239 crosshairTarget;
    @Shadow
    public abstract boolean isInSingleplayer();

    public MinecraftClientMixin(String string) {
        super(string);
    }


    /**
     * Allows the player to use the reachAround placement feature if enabled.
     */
    @Inject(method = "doItemUse", at = @At("HEAD"))
    private void bedrockify$modifyCrosshairTarget(CallbackInfo ci) {
        if (this.player == null) {
            return;
        }
        if (!BedrockifyClient.getInstance().settings.isReacharoundEnabled() || (!isInSingleplayer() && !BedrockifyClient.getInstance().settings.isReacharoundMultiplayerEnabled())) {
            return;
        }

        if (BedrockifyClient.getInstance().reachAroundPlacement.canReachAround()) {
            final class_746 player = this.player;
            final class_2338 targetPos = ReachAroundPlacement.getFacingSteppingBlockPos(player);
            this.crosshairTarget = new class_3965(new class_243(targetPos.method_10263(), player.method_23318(), targetPos.method_10260()), player.method_5735(), targetPos, false);
        }
    }
}
