package me.juancarloscp52.bedrockify.mixin.client.features.slotHighlight;

import me.juancarloscp52.bedrockify.client.BedrockifyClient;
import me.juancarloscp52.bedrockify.client.BedrockifyClientSettings;
import net.minecraft.class_1735;
import net.minecraft.class_332;
import net.minecraft.class_3934;
import net.minecraft.class_3979;
import net.minecraft.class_465;
import net.minecraft.class_479;
import net.minecraft.class_489;
import net.minecraft.class_492;
import net.minecraft.class_494;
import net.minecraft.client.gui.screen.ingame.*;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_465.class)
public abstract class HandledScreenMixin {
    @Unique
    private static final int LINE_RENDER_WIDTH = 1;
    @Unique
    private static final int SLOT_RENDER_SIZE = 16;
    @Unique
    private class_1735 currentSlot;

    @Shadow
    protected int x;
    @Shadow
    protected int y;

    @Shadow
    abstract boolean isPointOverSlot(class_1735 slot, double pointX, double pointY);

    @Inject(method = {"drawSlotHighlightBack", "drawSlotHighlightFront"}, at = @At("HEAD"), cancellable = true)
    private static void bedrockify$cancelVanillaHighlight(CallbackInfo ci) {
        BedrockifyClientSettings settings = BedrockifyClient.getInstance().settings;
        if (settings.isSlotHighlightEnabled()) {
            ci.cancel();
        }
    }

    @ModifyVariable(method = "renderMain", at = @At("STORE"))
    private class_1735 bedrockify$storeSlotInLoop(class_1735 slot) {
        this.currentSlot = slot;
        return slot;
    }

    /**
     * Draw the current slot in green.
     */
    @Inject(method = "renderMain", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/screen/ingame/HandledScreen;drawSlotHighlightBack(Lnet/minecraft/client/gui/DrawContext;)V"))
    private void bedrockify$customHighlightColor(class_332 drawContext, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        BedrockifyClientSettings settings = BedrockifyClient.getInstance().settings;
        if (!settings.isSlotHighlightEnabled() || this.currentSlot == null) {
            return;
        }
        if (!this.isPointOverSlot(currentSlot, mouseX, mouseY) || !currentSlot.method_7682()) {
            return;
        }

        final class_465<?> $this = class_465.class.cast(this);
        final int highlight1 = settings.getHighLightColor1();
        final int highlight2 = settings.getHighLightColor2();

        final int expandStartX, expandStartY, expandEndX, expandEndY;
        if (($this instanceof class_489 && currentSlot.field_7874 == 2) ||
                ($this instanceof class_479 && currentSlot.field_7874 == 0) ||
                ($this instanceof class_3979 && currentSlot.field_7874 == 1) ||
                ($this instanceof class_3934 && currentSlot.field_7874 == 2)
        ) {
            expandStartX = expandEndX = 4;
            expandStartY = expandEndY = 4;
        } else if ($this instanceof class_494 && currentSlot.field_7874 == 3) {
            expandStartX = expandEndX = 4;
            expandStartY = 5;
            expandEndY = 3;
        } else if ($this instanceof class_492 && currentSlot.field_7874 == 2) {
            expandStartX = expandEndX = 4;
            expandStartY = 3;
            expandEndY = 5;
        } else {
            expandStartX = expandEndX = expandStartY = expandEndY = 0;
        }

        final int fillStartX = currentSlot.field_7873 - expandStartX;
        final int fillStartY = currentSlot.field_7872 - expandStartY;
        final int fillEndX = currentSlot.field_7873 + expandEndX + SLOT_RENDER_SIZE;
        final int fillEndY = currentSlot.field_7872 + expandEndY + SLOT_RENDER_SIZE;
        final int outlineLeftX = fillStartX - LINE_RENDER_WIDTH;
        final int outlineTopY = fillStartY - LINE_RENDER_WIDTH;
        final int outlineRightX = fillEndX + LINE_RENDER_WIDTH;
        final int outlineBottomY = fillEndY + LINE_RENDER_WIDTH;

        // ** outlines
        // Top-horizontal
        drawContext.method_25294(outlineLeftX, outlineTopY, outlineRightX, outlineTopY + LINE_RENDER_WIDTH, highlight1);
        // Bottom-horizontal
        drawContext.method_25294(outlineLeftX, outlineBottomY - LINE_RENDER_WIDTH, outlineRightX, outlineBottomY, highlight1);
        // Left-vertical
        drawContext.method_25294(outlineLeftX, outlineTopY, outlineLeftX + LINE_RENDER_WIDTH, outlineBottomY, highlight1);
        // Right-vertical
        drawContext.method_25294(outlineRightX - LINE_RENDER_WIDTH, outlineTopY, outlineRightX, outlineBottomY, highlight1);
        // ** end of outlines

        // highlight
        drawContext.method_25294(fillStartX, fillStartY, fillEndX, fillEndY, highlight2);
    }
}
