package me.juancarloscp52.bedrockify.mixin.client.features.useAnimations;

import me.juancarloscp52.bedrockify.client.features.useAnimations.AnimationsHelper;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1723;
import net.minecraft.class_1799;
import net.minecraft.class_2649;
import net.minecraft.class_2653;
import net.minecraft.class_310;
import net.minecraft.class_634;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Environment(EnvType.CLIENT)
@Mixin(class_634.class)
public abstract class ClientPlayNetworkHandlerMixin {

    /**
     * Animate always by receiving S2C packet.<br>
     * Original method prevents the bobbing animation when decrementing and damaging.
     *
     * @see class_634#method_11109
     */
    @Inject(method = "onScreenHandlerSlotUpdate", at = @At("RETURN"))
    private void bedrockify$animateAlwaysSlotUpdate(class_2653 packet, CallbackInfo ci) {
        final class_1799 itemStack = packet.method_11449();
        final int slotIdx = packet.method_11450();
        if (packet.method_11452() != 0 && !class_1723.method_36211(slotIdx) || itemStack == null) {
            return;
        }

        AnimationsHelper.doBobbingAnimation(itemStack);
    }

    /**
     * Animate always by receiving S2C packet.<br>
     * This handles a packet that could not be caught by {@link class_634#method_11109}.
     *
     * @see class_634#method_11153
     */
    @Inject(method = "onInventory", at = @At("RETURN"))
    private void bedrockify$animateAlwaysInventory(class_2649 packet, CallbackInfo ci) {
        final class_1657 player = class_310.method_1551().field_1724;
        if (packet.comp_3837() != 0 || player == null) {
            return;
        }

        final int target = AnimationsHelper.consumeChangedSlot();
        if (!class_1661.method_7380(target) && target != class_1661.field_30639) {
            return;
        }

        AnimationsHelper.doBobbingAnimation(player.method_31548().method_5438(target));
    }
}
