package me.juancarloscp52.bedrockify.mixin.common.features.recipes;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import me.juancarloscp52.bedrockify.Bedrockify;
import me.juancarloscp52.bedrockify.common.features.recipes.DyeHelper;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1853;
import net.minecraft.class_1856;
import net.minecraft.class_1937;
import net.minecraft.class_7225;
import net.minecraft.class_9283;
import net.minecraft.class_9334;
import net.minecraft.class_9694;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;

import java.util.Map;

@Mixin(class_1853.class)
public class FireworkStarRecipeMixin {

    @Shadow @Final private static Map<class_1792, class_9283.class_1782> TYPE_MODIFIER_MAP;

    @Shadow @Final private static class_1856 FLICKER_MODIFIER;

    @Shadow @Final private static class_1856 TRAIL_MODIFIER;

    @Shadow @Final private static class_1856 GUNPOWDER;

    @ModifyReturnValue(method = "matches(Lnet/minecraft/recipe/input/CraftingRecipeInput;Lnet/minecraft/world/World;)Z", at = @At("RETURN"))
    public boolean matches(boolean original, class_9694 craftingInventory, class_1937 world) {
        if(!Bedrockify.getInstance().settings.isBedrockRecipesEnabled())
            return original;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;

        for(int i = 0; i < craftingInventory.method_59983(); ++i) {
            class_1799 itemStack = craftingInventory.method_59984(i);
            if (!itemStack.method_7960()) {
                if (TYPE_MODIFIER_MAP.containsKey(itemStack.method_7909())) {
                    if (bl3) {
                        return original;
                    }

                    bl3 = true;
                } else if (FLICKER_MODIFIER.method_8093(itemStack)) {
                    if (bl5) {
                        return original;
                    }

                    bl5 = true;
                } else if (TRAIL_MODIFIER.method_8093(itemStack)) {
                    if (bl4) {
                        return original;
                    }

                    bl4 = true;
                } else if (GUNPOWDER.method_8093(itemStack)) {
                    if (bl) {
                        return original;
                    }

                    bl = true;
                } else {
                    if (!(DyeHelper.isDyeableItem(itemStack.method_7909()))) {
                        return original;
                    }

                    bl2 = true;
                }
            }
        }
        return original || (bl && bl2);
    }

    @ModifyReturnValue(method = "craft(Lnet/minecraft/recipe/input/CraftingRecipeInput;Lnet/minecraft/registry/RegistryWrapper$WrapperLookup;)Lnet/minecraft/item/ItemStack;", at = @At("RETURN"))
    public class_1799 craft(class_1799 original, class_9694 craftingInventory, class_7225.class_7874 wrapperLookup) {
        if(!Bedrockify.getInstance().settings.isBedrockRecipesEnabled())
            return original;
        class_1799 itemStack = new class_1799(class_1802.field_8450);
        class_9283.class_1782 type = class_9283.class_1782.field_7976;
        IntList list = new IntArrayList();
        boolean hasTwinkleMod = false;
        boolean hasTrailMod = false;

        for(int i = 0; i < craftingInventory.method_59983(); ++i) {
            class_1799 itemStack2 = craftingInventory.method_59984(i);
            if (!itemStack2.method_7960()) {
                if (TYPE_MODIFIER_MAP.containsKey(itemStack2.method_7909())) {
                    type = TYPE_MODIFIER_MAP.get(itemStack2.method_7909());
                } else if (FLICKER_MODIFIER.method_8093(itemStack2)) {
                    hasTwinkleMod = true;
                } else if (TRAIL_MODIFIER.method_8093(itemStack2)) {
                    hasTrailMod = true;
                } else if (DyeHelper.isDyeableItem(itemStack2.method_7909())) {
                    list.add((DyeHelper.getDyeItem(itemStack2.method_7909()).method_7802().method_7790()));
                }
            }
        }

        itemStack.method_57379(class_9334.field_49615, new class_9283(type, list, IntList.of(), hasTrailMod, hasTwinkleMod));
        return itemStack;
    }

}
