package me.juancarloscp52.bedrockify.mixin.common.features.recipes;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import me.juancarloscp52.bedrockify.Bedrockify;
import net.minecraft.class_1863;
import net.minecraft.class_2960;
import net.minecraft.class_8786;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;

import java.util.List;
import java.util.Set;

@Mixin(class_1863.class)
public abstract class RecipeManagerMixin {

    @Unique
    private static class_2960 bedrockify$getIdFromRecipeEntry(class_8786<?> entry) {
        return entry.comp_1932().method_29177();
    }

    @ModifyArg(method = "prepare(Lnet/minecraft/resource/ResourceManager;Lnet/minecraft/util/profiler/Profiler;)Lnet/minecraft/recipe/PreparedRecipes;", at=@At(value = "INVOKE", target = "Lnet/minecraft/recipe/PreparedRecipes;of(Ljava/lang/Iterable;)Lnet/minecraft/recipe/PreparedRecipes;"), index = 0)
    public Iterable<class_8786<?>> prepareRecipes(Iterable<class_8786<?>> original){
        final List<class_8786<?>> editable = Lists.newArrayList(original);
        final var editableIter = editable.iterator();

        final boolean bBERecipeEnabled = Bedrockify.getInstance().settings.isBedrockRecipesEnabled();

        // --- Procedure of Recipe modification.

        // namespace equals ${Bedrockify.MOD_ID}
        final Set<String> bedrockifyRecipeIds = Sets.newHashSet(
                editable.stream()
                        .filter(entry -> bedrockify$getIdFromRecipeEntry(entry).method_12836().equals(Bedrockify.MOD_ID))
                        .map(entry -> bedrockify$getIdFromRecipeEntry(entry).method_12832())
                        .toList()
        );

        // Identifier#path contains in both vanilla and bedrockify
        final Set<String> moddedRecipeIds = Sets.newHashSet(
                editable.stream()
                        .filter(entry -> {
                            final class_2960 id = bedrockify$getIdFromRecipeEntry(entry);
                            return id.method_12836().equals(class_2960.field_33381) && bedrockifyRecipeIds.contains(id.method_12832());
                        })
                        .map(entry -> bedrockify$getIdFromRecipeEntry(entry).method_12832())
                        .toList()
        );

        // Process all the Recipes.
        while (editableIter.hasNext()) {
            var elem = editableIter.next();
            final class_2960 recipeId = elem.comp_1932().method_29177();
            final boolean bBERecipeIgnore = !bBERecipeEnabled && recipeId.method_12836().equals(Bedrockify.MOD_ID);
            final boolean bConflictedVanillaRecipe = bBERecipeEnabled && moddedRecipeIds.contains(recipeId.method_12832()) && recipeId.method_12836().equals(class_2960.field_33381);

            if (bBERecipeIgnore || bConflictedVanillaRecipe) {
                editableIter.remove();
            }
        }

        return editable;
    }
}
