/*
 * Decompiled with CFR 0.152.
 */
package me.juancarloscp52.bedrockify.client.features.loadingScreens;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Random;
import java.util.Set;
import me.juancarloscp52.bedrockify.client.features.loadingScreens.ExternalLoadingTips;
import net.minecraft.class_10799;
import net.minecraft.class_1132;
import net.minecraft.class_1934;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_8020;
import net.minecraft.class_9848;

public class LoadingScreenWidget {
    private static LoadingScreenWidget instance = null;
    private class_1934 gameMode = class_1934.field_9215;
    private static final int TIPS_NUM = 109;
    private static final int CREATIVE_TIPS_NUM = 24;
    private final class_2960 WIDGET_TEXTURE = class_2960.method_60655((String)"bedrockify", (String)"textures/gui/bedrockify_widgets.png");
    private class_2561 tip;
    private static final Set<Integer> EXCLUDED_TIPS = Sets.newHashSet();
    private long lastTipUpdate = 0L;
    private final ExternalLoadingTips externalLoadingTips = ExternalLoadingTips.loadSettings();
    private final class_8020 logoDrawer;

    private LoadingScreenWidget() {
        this.externalLoadingTips.saveSettings();
        this.logoDrawer = new class_8020(false);
    }

    public static LoadingScreenWidget getInstance() {
        if (instance == null) {
            instance = new LoadingScreenWidget();
        }
        return instance;
    }

    private class_2561 getTip() {
        if (this.hasChangedGameMode()) {
            this.tip = null;
        }
        if (this.tip == null || System.currentTimeMillis() - this.lastTipUpdate > 6000L) {
            Random randomGenerator = new Random();
            class_1132 server = class_310.method_1551().method_1576();
            if (server != null && server.method_3790() == class_1934.field_9220) {
                this.tip = class_2561.method_43471((String)("bedrockify.loadingTips.creative." + randomGenerator.nextInt(1, 24)));
            } else {
                int externalTipsLength = this.externalLoadingTips.length();
                int random = randomGenerator.nextInt(1, 110 + externalTipsLength);
                if (externalTipsLength > 0 && (random > 109 || this.externalLoadingTips.alwaysExternalTips)) {
                    this.tip = class_2561.method_43470((String)this.externalLoadingTips.get(randomGenerator.nextInt(externalTipsLength)));
                } else {
                    if (EXCLUDED_TIPS.contains(random)) {
                        return this.getTip();
                    }
                    this.tip = class_2561.method_43471((String)("bedrockify.loadingTips." + random));
                }
            }
            this.lastTipUpdate = System.currentTimeMillis();
        }
        return this.tip;
    }

    private boolean hasChangedGameMode() {
        class_1934 current = this.getCurrentGameMode();
        if (this.gameMode != current) {
            this.gameMode = current;
            return true;
        }
        return false;
    }

    private class_1934 getCurrentGameMode() {
        class_1132 server = class_310.method_1551().method_1576();
        return server == null ? class_1934.field_9215 : server.method_3790();
    }

    public void render(class_332 drawContext, int width, int height, class_2561 title, class_2561 message, int progress) {
        class_310 client = class_310.method_1551();
        this.logoDrawer.method_48210(drawContext, client.method_22683().method_4486(), 1.0f, height / 2 - 44);
        this.renderLoadingWidget(drawContext, width, height);
        class_327 textRenderer = class_310.method_1551().field_1772;
        drawContext.method_51439(textRenderer, title, width - textRenderer.method_27525((class_5348)title) / 2, height - 4 - 32, class_9848.method_61334((int)0x4C4C4C), false);
        this.renderTextBody(drawContext, width, height, message, textRenderer);
        if (progress >= 0) {
            this.renderLoadingBar(drawContext, width, height, progress);
        }
    }

    private void renderLoadingWidget(class_332 drawContext, int x, int y) {
        drawContext.method_25290(class_10799.field_56883, this.WIDGET_TEXTURE, x - 128, y - 44, 0.0f, 0.0f, 256, 89, 256, 256);
    }

    private void renderTextBody(class_332 drawContext, int x, int y, class_2561 message, class_327 textRenderer) {
        if (message == null) {
            message = this.getTip();
        }
        List text = textRenderer.method_1728((class_5348)message, 230);
        int maxLineWidth = this.getMaxLineWidth(textRenderer, text);
        for (int i = 0; i < 4 && i < text.size(); ++i) {
            drawContext.method_51430(textRenderer, (class_5481)text.get(i), x - maxLineWidth / 2, y - 15 + i * 9, -1, false);
        }
    }

    private int getMaxLineWidth(class_327 textRenderer, List<class_5481> text) {
        int maxLineWidth = 0;
        for (int i = 0; i < 4 && i < text.size(); ++i) {
            int lineWidth = textRenderer.method_30880(text.get(i));
            if (lineWidth <= maxLineWidth) continue;
            maxLineWidth = lineWidth;
        }
        return maxLineWidth;
    }

    private void renderLoadingBar(class_332 drawContext, int x, int y, int progress) {
        int barProgress = (int)((float)class_3532.method_15340((int)progress, (int)0, (int)100) / 100.0f * 223.0f);
        drawContext.method_25290(class_10799.field_56883, this.WIDGET_TEXTURE, x - 111, y + 26, 0.0f, 89.0f, 222, 5, 256, 256);
        if (barProgress > 0) {
            drawContext.method_25290(class_10799.field_56883, this.WIDGET_TEXTURE, x - 111, y + 26, 0.0f, 94.0f, barProgress, 5, 256, 256);
        }
    }
}

