/*
 * Decompiled with CFR 0.152.
 */
package me.juancarloscp52.bedrockify.common.block;

import com.mojang.serialization.MapCodec;
import me.juancarloscp52.bedrockify.Bedrockify;
import me.juancarloscp52.bedrockify.common.block.AbstractBECauldronBlock;
import me.juancarloscp52.bedrockify.common.block.cauldron.BedrockCauldronBehavior;
import me.juancarloscp52.bedrockify.common.features.cauldron.BedrockCauldronBlocks;
import me.juancarloscp52.bedrockify.common.features.cauldron.BedrockCauldronProperties;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2275;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2398;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3532;
import net.minecraft.class_4970;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_9381;

public class PotionCauldronBlock
extends AbstractBECauldronBlock {
    public static final MapCodec<PotionCauldronBlock> CODEC = PotionCauldronBlock.method_54094(PotionCauldronBlock::new);
    public static final class_2758 LEVEL = BedrockCauldronProperties.LEVEL_8;
    public static final int MAX_LEVEL = 8;
    public static final int BOTTLE_LEVEL = 3;
    public static final int ARROW_TIP_LEVEL_PER_STEP = 2;
    private static final int ARROW_TIP_STEP = 4;

    public PotionCauldronBlock(class_4970.class_2251 settings) {
        super(settings, BedrockCauldronBehavior.POTION_CAULDRON_BEHAVIOR);
        this.method_9590((class_2680)((class_2680)this.method_9595().method_11664()).method_11657((class_2769)LEVEL, (Comparable)Integer.valueOf(2)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{LEVEL});
    }

    public boolean method_32766(class_2680 state) {
        return (Integer)state.method_11654((class_2769)LEVEL) == 8;
    }

    public int method_9572(class_2680 state, class_1937 world, class_2338 pos, class_2350 direction) {
        return (int)Math.ceil((float)((Integer)state.method_11654((class_2769)LEVEL)).intValue() / 8.0f * 3.0f);
    }

    protected MapCodec<? extends class_2275> method_53969() {
        return CODEC;
    }

    public double method_31615(class_2680 state) {
        return class_3532.method_16436((double)((float)((Integer)state.method_11654((class_2769)LEVEL)).intValue() / 8.0f), (double)0.375, (double)0.9375);
    }

    public boolean method_9542(class_2680 state) {
        return true;
    }

    public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 random) {
        if (world == null || pos == null || state == null) {
            return;
        }
        if (random.method_43054() % 7 != 0) {
            return;
        }
        world.method_35230(pos, BedrockCauldronBlocks.WATER_CAULDRON_ENTITY).ifPresent(blockEntity -> {
            double offsetY;
            int effectColor = blockEntity.getTintColor();
            float red = (float)(effectColor >> 16 & 0xFF) / 255.0f;
            float green = (float)(effectColor >> 8 & 0xFF) / 255.0f;
            float blue = (float)(effectColor & 0xFF) / 255.0f;
            class_2248 patt0$temp = state.method_26204();
            if (patt0$temp instanceof PotionCauldronBlock) {
                PotionCauldronBlock potionCauldronBlock = (PotionCauldronBlock)patt0$temp;
                offsetY = potionCauldronBlock.method_31615(state);
            } else {
                offsetY = 0.5;
            }
            double x = (double)pos.method_10263() + 0.45 + random.method_43058() * 0.2;
            double y = (double)pos.method_10264() + offsetY;
            double z = (double)pos.method_10260() + 0.45 + random.method_43058() * 0.2;
            world.method_8406((class_2394)class_9381.method_58255((class_2396)class_2398.field_11226, (float)red, (float)green, (float)blue), x, y, z, (double)red, (double)green, (double)blue);
        });
    }

    public static boolean tryPickFluid(class_2680 state, class_1937 world, class_2338 pos) {
        if (world.method_8608()) {
            return false;
        }
        if (!state.method_28498((class_2769)LEVEL)) {
            Bedrockify.LOGGER.error("[{}] cannot retrieve fluid level", (Object)Bedrockify.class.getSimpleName(), (Object)new IllegalStateException("BlockState of %s does not have state: %s".formatted(state.method_26204(), LEVEL)));
            return false;
        }
        int currentLevel = (Integer)state.method_11654((class_2769)LEVEL);
        if (currentLevel < 2) {
            return false;
        }
        int nextLevel = currentLevel - 3;
        class_2680 blockState = nextLevel <= 0 ? class_2246.field_10593.method_9564() : (class_2680)state.method_11657((class_2769)LEVEL, (Comparable)Integer.valueOf(nextLevel));
        world.method_8501(pos, blockState);
        world.method_43276((class_6880)class_5712.field_28733, pos, class_5712.class_7397.method_43287((class_2680)blockState));
        return true;
    }

    public static int getMaxTippedArrowCount(class_1799 itemStack, class_2680 state) {
        if (!state.method_28498((class_2769)LEVEL)) {
            Bedrockify.LOGGER.error("[{}] cannot retrieve fluid level", (Object)Bedrockify.class.getSimpleName(), (Object)new IllegalStateException("BlockState of %s does not have the state: LEVEL".formatted(state.method_26204())));
            return 0;
        }
        int mul = (int)Math.floor((float)((Integer)state.method_11654((class_2769)LEVEL)).intValue() / 2.0f);
        return Math.min(PotionCauldronBlock.getArrowTipStepCount(itemStack) * mul, itemStack.method_7947());
    }

    public static int getDecLevelByStack(class_1799 itemStack, int count) {
        if (count <= 0) {
            return 0;
        }
        int step = (int)Math.ceil((float)count / (float)PotionCauldronBlock.getArrowTipStepCount(itemStack));
        return (step + (step >> 1)) * 2 - (step - 1);
    }

    private static int getArrowTipStepCount(class_1799 itemStack) {
        return (int)Math.ceil((float)itemStack.method_7914() / 4.0f);
    }
}

