/*
 * Decompiled with CFR 0.152.
 */
package whisperersjungletemple.init;

import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import whisperersjungletemple.entity.JungleSpiderEntity;
import whisperersjungletemple.entity.WhispererEntity;

@EventBusSubscriber
public class WhisperersJungleTempleModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"whisperers_jungle_temple");
    public static final DeferredHolder<EntityType<?>, EntityType<WhispererEntity>> WHISPERER = WhisperersJungleTempleModEntities.register("whisperer", EntityType.Builder.of(WhispererEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).ridingOffset(-0.6f).sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<JungleSpiderEntity>> JUNGLE_SPIDER = WhisperersJungleTempleModEntities.register("jungle_spider", EntityType.Builder.of(JungleSpiderEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(1.4f, 0.9f));

    private static <T extends Entity> DeferredHolder<EntityType<?>, EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.build(ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"whisperers_jungle_temple", (String)registryname))));
    }

    @SubscribeEvent
    public static void init(RegisterSpawnPlacementsEvent event) {
        WhispererEntity.init(event);
        JungleSpiderEntity.init(event);
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)WHISPERER.get(), WhispererEntity.createAttributes().build());
        event.put((EntityType)JUNGLE_SPIDER.get(), JungleSpiderEntity.createAttributes().build());
    }
}

