/*
 * Decompiled with CFR 0.152.
 */
package net.f4rck.stuffaintcheap.event;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import java.util.Map;
import net.f4rck.stuffaintcheap.enums.EnchantedItemEnum;
import net.f4rck.stuffaintcheap.enums.armor.EnchantedBootsEnum;
import net.f4rck.stuffaintcheap.enums.armor.EnchantedChestplateEnum;
import net.f4rck.stuffaintcheap.enums.armor.EnchantedHelmetEnum;
import net.f4rck.stuffaintcheap.enums.armor.EnchantedLeggingsEnum;
import net.f4rck.stuffaintcheap.utils.TradeUtils;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.village.VillagerTradesEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventBusSubscriber(modid="stuff_aint_cheap", bus=EventBusSubscriber.Bus.GAME)
public class ArmorerEvents {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArmorerEvents.class);

    @SubscribeEvent
    public static void addCustomTrades(VillagerTradesEvent event) {
        if (event.getType() != VillagerProfession.ARMORER) {
            return;
        }
        LOGGER.info("Starting ARMORER trades modification process...");
        Map vanillaTradesMap = VillagerTrades.TRADES;
        Int2ObjectMap vanillaTrades = (Int2ObjectMap)vanillaTradesMap.get(VillagerProfession.ARMORER);
        Int2ObjectMap trades = event.getTrades();
        LOGGER.info("Processing Level 4 trades...");
        TradeUtils.clearVanillaTrades((Int2ObjectMap<List<VillagerTrades.ItemListing>>)trades, (Int2ObjectMap<VillagerTrades.ItemListing[]>)vanillaTrades, 4);
        TradeUtils.addEnchantedItemTrades((Int2ObjectMap)trades, (int)4, (EnchantedItemEnum[])EnchantedBootsEnum.values(), (Item)Items.DIAMOND_BOOTS, (int)3, (int)50, (float)0.4f);
        TradeUtils.addEnchantedItemTrades((Int2ObjectMap)trades, (int)4, (EnchantedItemEnum[])EnchantedLeggingsEnum.values(), (Item)Items.DIAMOND_LEGGINGS, (int)3, (int)50, (float)0.4f);
        int level4Trades = EnchantedBootsEnum.values().length + EnchantedLeggingsEnum.values().length;
        LOGGER.info("Added {} enchanted armor trades to Level 4 ({} boots, {} leggings)", new Object[]{level4Trades, EnchantedBootsEnum.values().length, EnchantedLeggingsEnum.values().length});
        LOGGER.info("Processing Level 5 trades...");
        TradeUtils.clearVanillaTrades((Int2ObjectMap<List<VillagerTrades.ItemListing>>)trades, (Int2ObjectMap<VillagerTrades.ItemListing[]>)vanillaTrades, 5);
        TradeUtils.addEnchantedItemTrades((Int2ObjectMap)trades, (int)5, (EnchantedItemEnum[])EnchantedHelmetEnum.values(), (Item)Items.DIAMOND_HELMET, (int)3, (int)50, (float)0.4f);
        TradeUtils.addEnchantedItemTrades((Int2ObjectMap)trades, (int)5, (EnchantedItemEnum[])EnchantedChestplateEnum.values(), (Item)Items.DIAMOND_CHESTPLATE, (int)3, (int)50, (float)0.4f);
        int level5Trades = EnchantedHelmetEnum.values().length + EnchantedChestplateEnum.values().length;
        LOGGER.info("Added {} enchanted armor trades to Level 5 ({} helmets, {} chestplates)", new Object[]{level5Trades, EnchantedHelmetEnum.values().length, EnchantedChestplateEnum.values().length});
        int totalTrades = level4Trades + level5Trades;
        LOGGER.info("=== ARMORER TRADES MODIFICATION COMPLETED ===");
        LOGGER.info("Total custom trades added: {}", (Object)totalTrades);
        LOGGER.info("  - Level 4: {} armor pieces (boots & leggings)", (Object)level4Trades);
        LOGGER.info("  - Level 5: {} armor pieces (helmets & chestplates)", (Object)level5Trades);
        LOGGER.info("Vanilla trades cleared for levels 4 and 5");
        LOGGER.info("==============================================");
    }
}

