/*
 * Decompiled with CFR 0.152.
 */
package net.f4rck.stuffaintcheap.event;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import java.util.Map;
import net.f4rck.stuffaintcheap.enums.EnchantedItemEnum;
import net.f4rck.stuffaintcheap.enums.weapons.EnchantedAxeAttackEnum;
import net.f4rck.stuffaintcheap.enums.weapons.EnchantedSwordEnum;
import net.f4rck.stuffaintcheap.utils.TradeUtils;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.village.VillagerTradesEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventBusSubscriber(modid="stuff_aint_cheap", bus=EventBusSubscriber.Bus.GAME)
public class WeaponSmithEvents {
    private static final Logger LOGGER = LoggerFactory.getLogger(WeaponSmithEvents.class);

    @SubscribeEvent
    public static void addCustomTrades(VillagerTradesEvent event) {
        if (event.getType() != VillagerProfession.WEAPONSMITH) {
            return;
        }
        LOGGER.info("Starting WEAPONSMITH trades modification process...");
        Map vanillaTradesMap = VillagerTrades.TRADES;
        Int2ObjectMap vanillaTrades = (Int2ObjectMap)vanillaTradesMap.get(VillagerProfession.WEAPONSMITH);
        Int2ObjectMap trades = event.getTrades();
        LOGGER.info("Processing Level 3 trades...");
        TradeUtils.clearVanillaTrades((Int2ObjectMap<List<VillagerTrades.ItemListing>>)trades, (Int2ObjectMap<VillagerTrades.ItemListing[]>)vanillaTrades, 3);
        ((List)trades.get(3)).add(TradeUtils.createSimpleTrade(Items.DIAMOND, 1, Items.EMERALD, 1, 3, 25, 0.4f));
        LOGGER.info("Added 1 custom trade to Level 3: Diamond -> Emerald");
        LOGGER.info("Processing Level 4 trades...");
        TradeUtils.clearVanillaTrades((Int2ObjectMap<List<VillagerTrades.ItemListing>>)trades, (Int2ObjectMap<VillagerTrades.ItemListing[]>)vanillaTrades, 4);
        TradeUtils.addEnchantedItemTrades((Int2ObjectMap)trades, (int)4, (EnchantedItemEnum[])EnchantedAxeAttackEnum.values(), (Item)Items.DIAMOND_AXE, (int)3, (int)50, (float)0.4f);
        LOGGER.info("Added {} enchanted diamond axe trades to Level 4", (Object)EnchantedAxeAttackEnum.values().length);
        LOGGER.info("Processing Level 5 trades...");
        TradeUtils.clearVanillaTrades((Int2ObjectMap<List<VillagerTrades.ItemListing>>)trades, (Int2ObjectMap<VillagerTrades.ItemListing[]>)vanillaTrades, 5);
        TradeUtils.addEnchantedItemTrades((Int2ObjectMap)trades, (int)5, (EnchantedItemEnum[])EnchantedSwordEnum.values(), (Item)Items.DIAMOND_SWORD, (int)3, (int)50, (float)0.4f);
        LOGGER.info("Added {} enchanted diamond sword trades to Level 5", (Object)EnchantedSwordEnum.values().length);
        int totalTrades = 1 + EnchantedAxeAttackEnum.values().length + EnchantedSwordEnum.values().length;
        LOGGER.info("=== WEAPONSMITH TRADES MODIFICATION COMPLETED ===");
        LOGGER.info("Total custom trades added: {}", (Object)totalTrades);
        LOGGER.info("================================================");
    }
}

