/*
 * Decompiled with CFR 0.152.
 */
package net.f4rck.stuffaintcheap.utils;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.f4rck.stuffaintcheap.enums.EnchantedBookEnum;
import net.f4rck.stuffaintcheap.enums.EnchantedItemEnum;
import net.f4rck.stuffaintcheap.enums.SimpleItemEnum;
import net.f4rck.stuffaintcheap.event.registry.GetRegistryEnchantmentUtil;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TradeUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(TradeUtils.class);

    public static void clearVanillaTrades(Int2ObjectMap<List<VillagerTrades.ItemListing>> trades, Int2ObjectMap<VillagerTrades.ItemListing[]> vanillaTrades, int level) {
        VillagerTrades.ItemListing[] vanillaLevelTrades = (VillagerTrades.ItemListing[])vanillaTrades.get(level);
        if (vanillaLevelTrades == null || !trades.containsKey(level)) {
            return;
        }
        HashSet<Class> vanillaTradeClasses = new HashSet<Class>();
        for (VillagerTrades.ItemListing vanillaTrade : vanillaLevelTrades) {
            if (vanillaTrade == null) continue;
            vanillaTradeClasses.add(vanillaTrade.getClass());
        }
        int removedCount = 0;
        Iterator iterator = ((List)trades.get(level)).iterator();
        while (iterator.hasNext()) {
            Class tradeClass;
            boolean isVanillaTrade;
            VillagerTrades.ItemListing trade = (VillagerTrades.ItemListing)iterator.next();
            if (trade == null || !(isVanillaTrade = vanillaTradeClasses.contains(tradeClass = trade.getClass()))) continue;
            iterator.remove();
            ++removedCount;
            LOGGER.debug("Removing vanilla trade of class {} from level {}", (Object)tradeClass.getSimpleName(), (Object)level);
        }
        if (removedCount > 0) {
            LOGGER.info("Removed {} vanilla trades from level {}", (Object)removedCount, (Object)level);
        }
    }

    public static VillagerTrades.ItemListing createSimpleTrade(ItemCost cost, ItemStack result, int maxUses, int xp, float priceMultiplier) {
        return (pTrader, pRandom) -> new MerchantOffer(cost, result, maxUses, xp, priceMultiplier);
    }

    public static VillagerTrades.ItemListing createDualCostTrade(ItemCost primaryCost, ItemCost secondaryCost, ItemStack result, int maxUses, int xp, float priceMultiplier) {
        return (pTrader, pRandom) -> new MerchantOffer(primaryCost, Optional.of(secondaryCost), result, maxUses, xp, priceMultiplier);
    }

    public static <T extends EnchantedItemEnum> void addEnchantedItemTrades(Int2ObjectMap<List<VillagerTrades.ItemListing>> trades, int level, T[] enumValues, Item item, int maxUses, int xp, float priceMultiplier) {
        for (Object element : enumValues) {
            ((List)trades.get(level)).add((pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, element.getEmeraldsCost()), Optional.of(new ItemCost((ItemLike)Items.DIAMOND, element.getDiamondCost())), GetRegistryEnchantmentUtil.makeItemStack(item, (HolderLookup.Provider)pTrader.level().registryAccess(), element.getFirstEnchantment(), element.getSecondEnchantment(), element.getLevelOfFirstEnchantment(), element.getLevelOfSecondEnchantment()), maxUses, xp, priceMultiplier));
        }
    }

    public static <T extends EnchantedBookEnum> void addEnchantedBookTrades(Int2ObjectMap<List<VillagerTrades.ItemListing>> trades, int level, T[] enumValues, int maxUses, int xp, float priceMultiplier) {
        for (Object element : enumValues) {
            ((List)trades.get(level)).add((pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, element.getEmeraldsCost()), Optional.of(new ItemCost((ItemLike)Items.DIAMOND, element.getDiamondCost())), GetRegistryEnchantmentUtil.makeItemStack(Items.ENCHANTED_BOOK, (HolderLookup.Provider)pTrader.level().registryAccess(), element.getEnchantment(), null, element.getLevel(), 0), maxUses, xp, priceMultiplier));
        }
    }

    public static <T extends SimpleItemEnum> void addSimpleItemTrades(Int2ObjectMap<List<VillagerTrades.ItemListing>> trades, int level, T[] enumValues, float priceMultiplier) {
        for (T itemTrade : enumValues) {
            ((List)trades.get(level)).add(TradeUtils.createSimpleTrade(itemTrade.getItemCost(), itemTrade.getItemResult(), itemTrade.getMaxUses(), itemTrade.getXp(), priceMultiplier));
        }
    }
}

