/*
 * Decompiled with CFR 0.152.
 */
package net.f4rck.stuffaintcheap.event;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import java.util.Map;
import net.f4rck.stuffaintcheap.enums.EnchantedBookEnum;
import net.f4rck.stuffaintcheap.enums.SimpleItemEnum;
import net.f4rck.stuffaintcheap.enums.books.BookTier2Enum;
import net.f4rck.stuffaintcheap.enums.books.BookTier4Enum;
import net.f4rck.stuffaintcheap.enums.books.BookTier5Enum;
import net.f4rck.stuffaintcheap.enums.items.ItemsTier1;
import net.f4rck.stuffaintcheap.enums.items.ItemsTier3;
import net.f4rck.stuffaintcheap.utils.TradeUtils;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.village.VillagerTradesEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventBusSubscriber(modid="stuff_aint_cheap")
public class LibrarianEvents {
    private static final Logger LOGGER = LoggerFactory.getLogger(LibrarianEvents.class);

    @SubscribeEvent
    public static void addCustomTrades(VillagerTradesEvent event) {
        if (event.getType() != VillagerProfession.LIBRARIAN) {
            return;
        }
        LOGGER.info("Starting LIBRARIAN trades modification process...");
        Map vanillaTradesMap = VillagerTrades.TRADES;
        Int2ObjectMap vanillaTrades = (Int2ObjectMap)vanillaTradesMap.get(VillagerProfession.LIBRARIAN);
        Int2ObjectMap trades = event.getTrades();
        LOGGER.info("Processing Level 1 trades...");
        TradeUtils.clearVanillaTrades((Int2ObjectMap<List<VillagerTrades.ItemListing>>)trades, (Int2ObjectMap<VillagerTrades.ItemListing[]>)vanillaTrades, 1);
        TradeUtils.addSimpleItemTrades((Int2ObjectMap)trades, (int)1, (SimpleItemEnum[])ItemsTier1.values(), (float)0.05f);
        LOGGER.info("Added {} simple item trades to Level 1", (Object)ItemsTier1.values().length);
        LOGGER.info("Processing Level 2 trades...");
        TradeUtils.clearVanillaTrades((Int2ObjectMap<List<VillagerTrades.ItemListing>>)trades, (Int2ObjectMap<VillagerTrades.ItemListing[]>)vanillaTrades, 2);
        TradeUtils.addEnchantedBookTrades((Int2ObjectMap)trades, (int)2, (EnchantedBookEnum[])BookTier2Enum.values(), (int)3, (int)50, (float)0.4f);
        LOGGER.info("Added {} enchanted book trades to Level 2", (Object)BookTier2Enum.values().length);
        LOGGER.info("Processing Level 3 trades...");
        TradeUtils.clearVanillaTrades((Int2ObjectMap<List<VillagerTrades.ItemListing>>)trades, (Int2ObjectMap<VillagerTrades.ItemListing[]>)vanillaTrades, 3);
        TradeUtils.addSimpleItemTrades((Int2ObjectMap)trades, (int)3, (SimpleItemEnum[])ItemsTier3.values(), (float)0.05f);
        LOGGER.info("Added {} simple item trades to Level 3", (Object)ItemsTier3.values().length);
        LOGGER.info("Processing Level 4 trades...");
        TradeUtils.clearVanillaTrades((Int2ObjectMap<List<VillagerTrades.ItemListing>>)trades, (Int2ObjectMap<VillagerTrades.ItemListing[]>)vanillaTrades, 4);
        TradeUtils.addEnchantedBookTrades((Int2ObjectMap)trades, (int)4, (EnchantedBookEnum[])BookTier4Enum.values(), (int)3, (int)50, (float)0.4f);
        LOGGER.info("Added {} enchanted book trades to Level 4", (Object)BookTier4Enum.values().length);
        LOGGER.info("Processing Level 5 trades...");
        TradeUtils.clearVanillaTrades((Int2ObjectMap<List<VillagerTrades.ItemListing>>)trades, (Int2ObjectMap<VillagerTrades.ItemListing[]>)vanillaTrades, 5);
        TradeUtils.addEnchantedBookTrades((Int2ObjectMap)trades, (int)5, (EnchantedBookEnum[])BookTier5Enum.values(), (int)3, (int)50, (float)0.4f);
        LOGGER.info("Added {} enchanted book trades to Level 5", (Object)BookTier5Enum.values().length);
        int itemTrades = ItemsTier1.values().length + ItemsTier3.values().length;
        int bookTrades = BookTier2Enum.values().length + BookTier4Enum.values().length + BookTier5Enum.values().length;
        int totalTrades = itemTrades + bookTrades;
        LOGGER.info("=== LIBRARIAN TRADES MODIFICATION COMPLETED ===");
        LOGGER.info("Total custom trades added: {}", (Object)totalTrades);
        LOGGER.info("  - Simple items: {} trades (levels 1 & 3)", (Object)itemTrades);
        LOGGER.info("  - Enchanted books: {} trades (levels 2, 4 & 5)", (Object)bookTrades);
        LOGGER.info("Vanilla trades cleared for all levels (1-5)");
        LOGGER.info("===============================================");
    }
}

