/*
 * Decompiled with CFR 0.152.
 */
package net.f4rck.stuffaintcheap.event;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import java.util.Map;
import net.f4rck.stuffaintcheap.enums.EnchantedItemEnum;
import net.f4rck.stuffaintcheap.enums.tools.EnchantedAxeEnum;
import net.f4rck.stuffaintcheap.enums.tools.EnchantedPickaxeEnum;
import net.f4rck.stuffaintcheap.enums.tools.EnchantedShovelEnum;
import net.f4rck.stuffaintcheap.utils.TradeUtils;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.village.VillagerTradesEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventBusSubscriber(modid="stuff_aint_cheap")
public class ToolSmithEvents {
    private static final Logger LOGGER = LoggerFactory.getLogger(ToolSmithEvents.class);

    @SubscribeEvent
    public static void addCustomTrades(VillagerTradesEvent event) {
        if (event.getType() != VillagerProfession.TOOLSMITH) {
            return;
        }
        LOGGER.info("Starting TOOLSMITH trades modification process...");
        Map vanillaTradesMap = VillagerTrades.TRADES;
        Int2ObjectMap vanillaTrades = (Int2ObjectMap)vanillaTradesMap.get(VillagerProfession.TOOLSMITH);
        Int2ObjectMap trades = event.getTrades();
        LOGGER.info("Processing Level 4 trades...");
        TradeUtils.clearVanillaTrades((Int2ObjectMap<List<VillagerTrades.ItemListing>>)trades, (Int2ObjectMap<VillagerTrades.ItemListing[]>)vanillaTrades, 4);
        TradeUtils.addEnchantedItemTrades((Int2ObjectMap)trades, (int)4, (EnchantedItemEnum[])EnchantedShovelEnum.values(), (Item)Items.DIAMOND_SHOVEL, (int)3, (int)50, (float)0.4f);
        TradeUtils.addEnchantedItemTrades((Int2ObjectMap)trades, (int)4, (EnchantedItemEnum[])EnchantedAxeEnum.values(), (Item)Items.DIAMOND_AXE, (int)3, (int)50, (float)0.4f);
        int level4Trades = EnchantedShovelEnum.values().length + EnchantedAxeEnum.values().length;
        LOGGER.info("Added {} enchanted tool trades to Level 4 ({} shovels, {} axes)", new Object[]{level4Trades, EnchantedShovelEnum.values().length, EnchantedAxeEnum.values().length});
        LOGGER.info("Processing Level 5 trades...");
        TradeUtils.clearVanillaTrades((Int2ObjectMap<List<VillagerTrades.ItemListing>>)trades, (Int2ObjectMap<VillagerTrades.ItemListing[]>)vanillaTrades, 5);
        TradeUtils.addEnchantedItemTrades((Int2ObjectMap)trades, (int)5, (EnchantedItemEnum[])EnchantedPickaxeEnum.values(), (Item)Items.DIAMOND_PICKAXE, (int)3, (int)50, (float)0.4f);
        LOGGER.info("Added {} enchanted diamond pickaxe trades to Level 5", (Object)EnchantedPickaxeEnum.values().length);
        int totalTrades = level4Trades + EnchantedPickaxeEnum.values().length;
        LOGGER.info("=== TOOLSMITH TRADES MODIFICATION COMPLETED ===");
        LOGGER.info("Total custom trades added: {}", (Object)totalTrades);
        LOGGER.info("  - Level 4: {} tools (shovels & axes)", (Object)level4Trades);
        LOGGER.info("  - Level 5: {} pickaxes", (Object)EnchantedPickaxeEnum.values().length);
        LOGGER.info("Vanilla trades cleared for levels 4 and 5");
        LOGGER.info("============================================");
    }
}

