/*
 * Decompiled with CFR 0.152.
 */
package net.pearl.dynamism.entity.custom;

import java.util.EnumSet;
import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1335;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1400;
import net.minecraft.class_1405;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_4051;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_7094;
import net.minecraft.class_8046;
import net.minecraft.class_8103;
import net.pearl.dynamism.entity.custom.BruiseEntity;
import net.pearl.dynamism.particle.ModParticles;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HemophyterEntity
extends class_1588
implements class_8046 {
    @Nullable
    class_1308 owner;
    private class_2338 bounds;
    protected static final class_2940<Byte> HEMOPHYTER_FLAGS;
    private static final int CHARGING_FLAG = 1;
    protected static final class_2940<Integer> HOST_ID;
    public final class_7094 idleAnimationState = new class_7094();
    private int idleAnimationTimeout = 0;
    private static final Logger log;

    public HemophyterEntity(class_1299<? extends class_1588> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6207 = new HemophyterMoveControl(this);
        this.field_6194 = 0;
    }

    public void method_5784(class_1313 movementType, class_243 movement) {
        super.method_5784(movementType, movement);
        this.method_5852();
    }

    public boolean method_30949(class_1297 other) {
        return other instanceof BruiseEntity ? false : super.method_30949(other);
    }

    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(4, (class_1352)new ChargeTargetGoal());
        this.field_6201.method_6277(8, (class_1352)new LookAtTargetGoal());
        this.field_6201.method_6277(9, (class_1352)new class_1361((class_1308)this, class_1657.class, 3.0f, 1.0f));
        this.field_6201.method_6277(10, (class_1352)new class_1361((class_1308)this, class_1308.class, 8.0f));
        this.field_6185.method_6277(3, (class_1352)new TrackOwnerTargetGoal((class_1314)this));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1657.class, true));
    }

    public void method_5773() {
        this.method_5875(true);
        super.method_5773();
        this.field_5960 = false;
        if (this.method_37908().field_9236 && this.field_5974.method_43048(20) > 16) {
            this.method_37908().method_8406((class_2394)ModParticles.MAGIC_BLOOD_PARTICLE, this.method_23322(0.5), this.method_23319(), this.method_23325(0.5), (this.field_5974.method_43058() - 0.5) * (double)1.2f, (this.field_5974.method_43058() - 0.5) * (double)1.2f, (this.field_5974.method_43058() - 0.5) * (double)1.2f);
        }
        if (this.getOwner() != null) {
            if (this.method_5739((class_1297)this.getOwner()) > 8.0f | this.field_5974.method_43048(15) > 13 && !this.method_6510()) {
                this.field_6207.method_6239(this.getOwner().method_23317() + (double)this.field_5974.method_43048(1), this.getOwner().method_23318() + 3.0 + (double)this.field_5974.method_43048(1), this.getOwner().method_23321() + (double)this.field_5974.method_43048(1), 0.6);
            }
        } else if (this.field_5974.method_43048(20) > 19) {
            this.field_6207.method_6239(this.method_23317() + (double)this.field_5974.method_43048(3) - (double)this.field_5974.method_43048(3), this.method_23318() + (double)this.field_5974.method_43048(3) - (double)this.field_5974.method_43048(3), this.method_23321() + (double)this.field_5974.method_43048(3) - (double)this.field_5974.method_43048(3), 0.5);
        }
        if (this.method_37908().method_8608()) {
            this.setupAnimationStates();
        }
    }

    private void setupAnimationStates() {
        if (this.idleAnimationTimeout <= 0) {
            this.idleAnimationTimeout = 25;
            this.idleAnimationState.method_41322(this.field_6012);
        } else {
            --this.idleAnimationTimeout;
        }
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 15.0).method_26868(class_5134.field_23722, 1.1).method_26868(class_5134.field_23721, 3.0);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(HEMOPHYTER_FLAGS, (Object)0);
        builder.method_56912(HOST_ID, (Object)Integer.MIN_VALUE);
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        if (nbt.method_10545("BoundX")) {
            this.bounds = new class_2338(nbt.method_10550("BoundX"), nbt.method_10550("BoundY"), nbt.method_10550("BoundZ"));
        }
        if (this.getHostId() != Integer.MIN_VALUE) {
            nbt.method_10569("Host", this.getHostId());
        }
    }

    public void method_5878(class_1297 original) {
        super.method_5878(original);
        if (original instanceof HemophyterEntity) {
            HemophyterEntity hemophyterEntity = (HemophyterEntity)original;
            this.owner = hemophyterEntity.getOwner();
        }
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        int id = Integer.MIN_VALUE;
        if (nbt.method_10545("Host")) {
            id = nbt.method_10550("Host");
        }
        if (this.bounds != null) {
            nbt.method_10569("BoundX", this.bounds.method_10263());
            nbt.method_10569("BoundY", this.bounds.method_10264());
            nbt.method_10569("BoundZ", this.bounds.method_10260());
        }
        if (id != Integer.MIN_VALUE) {
            try {
                this.owner = (class_1308)this.method_37908().method_8469(id);
            }
            catch (Throwable var4) {
                this.setOwner(null);
            }
        }
    }

    @Nullable
    public class_1308 getOwner() {
        return this.owner;
    }

    public void setOwner(class_1308 owner) {
        this.owner = owner;
    }

    public int getHostId() {
        if (this.owner == null) {
            return Integer.MIN_VALUE;
        }
        return this.owner.method_5628();
    }

    public void setHostId(int ownerId) {
        this.field_6011.method_12778(HOST_ID, (Object)ownerId);
    }

    @Nullable
    public class_2338 getBounds() {
        return this.bounds;
    }

    private boolean areFlagsSet(int mask) {
        byte i = (Byte)this.field_6011.method_12789(HEMOPHYTER_FLAGS);
        return (i & mask) != 0;
    }

    private void setHemophyterFlag(int mask, boolean value) {
        int i = ((Byte)this.field_6011.method_12789(HEMOPHYTER_FLAGS)).byteValue();
        i = value ? (i |= mask) : (i &= ~mask);
        this.field_6011.method_12778(HEMOPHYTER_FLAGS, (Object)((byte)(i & 0xFF)));
    }

    public boolean isCharging() {
        return this.areFlagsSet(1);
    }

    public void setCharging(boolean charging) {
        this.setHemophyterFlag(1, charging);
    }

    protected class_3414 method_5994() {
        return class_3417.field_15083;
    }

    protected class_3414 method_6002() {
        return class_3417.field_14964;
    }

    protected class_3414 method_6011(class_1282 source) {
        return class_3417.field_14863;
    }

    @Nullable
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData) {
        if (this.getOwner() == null) {
            this.setHostId(Integer.MIN_VALUE);
        }
        return super.method_5943(world, difficulty, spawnReason, entityData);
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (source.method_48789(class_8103.field_42250)) {
            return false;
        }
        return super.method_5643(source, amount);
    }

    static {
        log = LoggerFactory.getLogger(HemophyterEntity.class);
        HEMOPHYTER_FLAGS = class_2945.method_12791(HemophyterEntity.class, (class_2941)class_2943.field_13319);
        HOST_ID = class_2945.method_12791(HemophyterEntity.class, (class_2941)class_2943.field_13327);
    }

    class HemophyterMoveControl
    extends class_1335 {
        public HemophyterMoveControl(HemophyterEntity owner) {
            super((class_1308)owner);
        }

        public void method_6240() {
            if (this.field_6374 == class_1335.class_1336.field_6378) {
                class_243 vec3d = new class_243(this.field_6370 - HemophyterEntity.this.method_23317(), this.field_6369 - HemophyterEntity.this.method_23318(), this.field_6367 - HemophyterEntity.this.method_23321());
                double d = vec3d.method_1033();
                if (d < HemophyterEntity.this.method_5829().method_995()) {
                    this.field_6374 = class_1335.class_1336.field_6377;
                    HemophyterEntity.this.method_18799(HemophyterEntity.this.method_18798().method_1021(0.5));
                } else {
                    HemophyterEntity.this.method_18799(HemophyterEntity.this.method_18798().method_1019(vec3d.method_1021(this.field_6372 * 0.05 / d)));
                    if (HemophyterEntity.this.method_5968() == null) {
                        class_243 vec3d2 = HemophyterEntity.this.method_18798();
                        HemophyterEntity.this.method_36456(-((float)class_3532.method_15349((double)vec3d2.field_1352, (double)vec3d2.field_1350)) * 57.295776f);
                        HemophyterEntity.this.field_6283 = HemophyterEntity.this.method_36454();
                    } else {
                        double e = HemophyterEntity.this.method_5968().method_23317() - HemophyterEntity.this.method_23317();
                        double f = HemophyterEntity.this.method_5968().method_23321() - HemophyterEntity.this.method_23321();
                        HemophyterEntity.this.method_36456(-((float)class_3532.method_15349((double)e, (double)f)) * 57.295776f);
                        HemophyterEntity.this.field_6283 = HemophyterEntity.this.method_36454();
                    }
                }
            }
        }
    }

    class ChargeTargetGoal
    extends class_1352 {
        public ChargeTargetGoal() {
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        }

        public boolean method_6264() {
            class_1309 livingEntity = HemophyterEntity.this.method_5968();
            if (livingEntity != null && livingEntity.method_5805() && !HemophyterEntity.this.method_5962().method_6241() && HemophyterEntity.this.field_5974.method_43048(ChargeTargetGoal.method_38848((int)7)) == 0) {
                return HemophyterEntity.this.method_5858((class_1297)livingEntity) > 4.0;
            }
            return false;
        }

        public boolean method_6266() {
            return HemophyterEntity.this.method_5962().method_6241() && HemophyterEntity.this.isCharging() && HemophyterEntity.this.method_5968() != null && HemophyterEntity.this.method_5968().method_5805();
        }

        public void method_6269() {
            class_1309 livingEntity = HemophyterEntity.this.method_5968();
            if (livingEntity != null) {
                class_243 vec3d = livingEntity.method_33571();
                HemophyterEntity.this.field_6207.method_6239(vec3d.field_1352, vec3d.field_1351, vec3d.field_1350, 1.0);
            }
            HemophyterEntity.this.setCharging(true);
        }

        public void method_6270() {
            HemophyterEntity.this.setCharging(false);
        }

        public boolean method_38846() {
            return true;
        }

        public void method_6268() {
            class_1309 livingEntity = HemophyterEntity.this.method_5968();
            if (livingEntity != null) {
                if (HemophyterEntity.this.method_5829().method_994(livingEntity.method_5829())) {
                    HemophyterEntity.this.method_6121((class_1297)livingEntity);
                    HemophyterEntity.this.setCharging(false);
                } else {
                    double d = HemophyterEntity.this.method_5858((class_1297)livingEntity);
                    if (d < 9.0) {
                        class_243 vec3d = livingEntity.method_33571();
                        HemophyterEntity.this.field_6207.method_6239(vec3d.field_1352, vec3d.field_1351, vec3d.field_1350, 1.0);
                    }
                }
            }
        }
    }

    class LookAtTargetGoal
    extends class_1352 {
        public LookAtTargetGoal() {
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        }

        public boolean method_6264() {
            return !HemophyterEntity.this.method_5962().method_6241() && HemophyterEntity.this.field_5974.method_43048(LookAtTargetGoal.method_38848((int)7)) == 0;
        }

        public boolean method_6266() {
            return false;
        }

        public void method_6268() {
            class_2338 blockPos = HemophyterEntity.this.getBounds();
            if (blockPos == null) {
                blockPos = HemophyterEntity.this.method_24515();
            }
            for (int i = 0; i < 3; ++i) {
                class_2338 blockPos2 = blockPos.method_10069(HemophyterEntity.this.field_5974.method_43048(15) - 7, HemophyterEntity.this.field_5974.method_43048(11) - 5, HemophyterEntity.this.field_5974.method_43048(15) - 7);
                if (!HemophyterEntity.this.method_37908().method_22347(blockPos2)) continue;
                HemophyterEntity.this.field_6207.method_6239((double)blockPos2.method_10263() + 0.5, (double)blockPos2.method_10264() + 0.5, (double)blockPos2.method_10260() + 0.5, 0.25);
                if (HemophyterEntity.this.method_5968() != null) break;
                HemophyterEntity.this.method_5988().method_6230((double)blockPos2.method_10263() + 0.5, (double)blockPos2.method_10264() + 0.5, (double)blockPos2.method_10260() + 0.5, 180.0f, 20.0f);
                break;
            }
        }
    }

    class TrackOwnerTargetGoal
    extends class_1405 {
        private final class_4051 targetPredicate;

        public TrackOwnerTargetGoal(class_1314 mob) {
            super((class_1308)mob, false);
            this.targetPredicate = class_4051.method_36626().method_18424();
        }

        public boolean method_6264() {
            return HemophyterEntity.this.owner != null && HemophyterEntity.this.owner.method_5968() != null && this.method_6328(HemophyterEntity.this.owner.method_5968(), this.targetPredicate);
        }

        public void method_6269() {
            HemophyterEntity.this.method_5980(HemophyterEntity.this.owner.method_5968());
            super.method_6269();
        }
    }
}

