/*
 * Decompiled with CFR 0.152.
 */
package net.pearl.dynamism.entity.custom;

import java.util.EnumSet;
import net.minecraft.class_11;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1439;
import net.minecraft.class_1588;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_7094;
import net.pearl.dynamism.entity.custom.BruiseEntity;
import net.pearl.dynamism.sounds.ModSounds;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlasherEntity
extends class_1588 {
    private static final Logger log = LoggerFactory.getLogger(SlasherEntity.class);
    public final class_7094 idleAnimationState = new class_7094();
    public final class_7094 attackingAnimationState = new class_7094();
    public final class_7094 lungingAnimationState = new class_7094();
    public final class_7094 shakeHeadAnimationState = new class_7094();
    private int idleAnimationTimeout = 0;

    public SlasherEntity(class_1299<? extends class_1588> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6194 = 20;
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new LungeAtTargetGoal((class_1308)this, 0.6f));
        this.field_6201.method_6277(4, (class_1352)new class_1394((class_1314)this, 1.0));
        this.field_6201.method_6277(5, (class_1352)new class_1361((class_1308)this, class_1309.class, 4.0f));
        this.field_6201.method_6277(3, (class_1352)new class_1376((class_1308)this));
        this.field_6201.method_6277(2, (class_1352)new AttackGoal(this));
        this.field_6185.method_6277(1, (class_1352)new class_1399((class_1314)this, new Class[0]));
        this.field_6185.method_6277(2, new TargetGoal<class_1657>(this, class_1657.class));
        this.field_6185.method_6277(2, new TargetGoal<class_1646>(this, class_1646.class));
        this.field_6185.method_6277(2, new TargetGoal<BruiseEntity>(this, BruiseEntity.class));
        this.field_6185.method_6277(2, new TargetGoal<class_1439>(this, class_1439.class));
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 25.0).method_26868(class_5134.field_47761, 1.0).method_26868(class_5134.field_23719, (double)0.2f).method_26868(class_5134.field_23723, 40.0).method_26868(class_5134.field_23717, 40.0).method_26868(class_5134.field_23721, 5.0);
    }

    public void method_5711(byte status) {
        if (status == 4) {
            this.attackingAnimationState.method_41322(this.field_6012);
        } else if (status == 61) {
            this.shakeHeadAnimationState.method_41322(this.field_6012);
        } else if (status == 59) {
            this.lungingAnimationState.method_41322(this.field_6012);
        } else {
            super.method_5711(status);
        }
    }

    private void setupAnimationStates() {
        if (this.idleAnimationTimeout <= 0) {
            this.idleAnimationTimeout = 89;
            this.idleAnimationState.method_41322(this.field_6012);
        } else {
            --this.idleAnimationTimeout;
        }
    }

    public boolean isRunning() {
        return this.method_6510();
    }

    public void method_5773() {
        super.method_5773();
        if (this.method_37908().method_8608()) {
            this.setupAnimationStates();
        }
        if (this.field_5974.method_43048(700) == 0) {
            this.method_37908().method_8421((class_1297)this, (byte)61);
        }
        if (this.method_6083() == 300) {
            this.method_37908().method_8421((class_1297)this, (byte)59);
        }
    }

    public boolean method_6121(class_1297 target) {
        if (!(target instanceof class_1309)) {
            return false;
        }
        if (this.method_6083() >= 50) {
            this.method_37908().method_8421((class_1297)this, (byte)4);
        }
        this.method_56078(ModSounds.SLASHER_SLASH);
        return super.method_6121(target);
    }

    @Nullable
    protected class_3414 method_5994() {
        return class_3417.field_23672;
    }

    @Nullable
    protected class_3414 method_6002() {
        return class_3417.field_14648;
    }

    @Nullable
    protected class_3414 method_6011(class_1282 source) {
        return class_3417.field_14940;
    }

    public class LungeAtTargetGoal
    extends class_1352 {
        private final class_1308 mob;
        private class_1309 target;
        private final float velocity;
        public int WaitUntilNextJumpTime = 50;

        public LungeAtTargetGoal(class_1308 mob, float velocity) {
            this.mob = mob;
            this.velocity = velocity;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18407, class_1352.class_4134.field_18405));
        }

        public void method_6268() {
            super.method_6268();
            if (SlasherEntity.this.method_6510()) {
                --this.WaitUntilNextJumpTime;
            }
        }

        public boolean method_6264() {
            if (this.mob.method_42148()) {
                return false;
            }
            this.target = this.mob.method_5968();
            if (this.target == null) {
                return false;
            }
            double d = this.mob.method_5858((class_1297)this.target);
            if (d > 3.0 && SlasherEntity.this.method_6083() >= 300 && this.WaitUntilNextJumpTime <= 0) {
                return this.mob.method_59922().method_43048(LungeAtTargetGoal.method_38848((int)5)) == 0;
            }
            return false;
        }

        public boolean method_6266() {
            return !this.mob.method_24828();
        }

        public void method_6269() {
            class_243 vec3d = this.mob.method_18798();
            class_243 vec3d2 = new class_243(this.target.method_23317() - this.mob.method_23317(), 0.0, this.target.method_23321() - this.mob.method_23321());
            if (vec3d2.method_1027() > 1.0E-7) {
                vec3d2 = vec3d2.method_1029().method_1021(0.1).method_1019(vec3d.method_1021(0.2));
            }
            this.WaitUntilNextJumpTime = 70;
            this.mob.method_18800(vec3d2.field_1352, (double)this.velocity, vec3d2.field_1350);
        }

        public boolean isLunging() {
            return true;
        }
    }

    static class AttackGoal
    extends SlashingAttackGoal {
        public AttackGoal(SlasherEntity slasher) {
            super((class_1314)slasher, 2.5, true);
        }

        @Override
        public boolean method_6264() {
            return super.method_6264() && !this.mob.method_5782();
        }
    }

    static class TargetGoal<T extends class_1309>
    extends class_1400<T> {
        public TargetGoal(SlasherEntity slasher, Class<T> targetEntityClass) {
            super((class_1308)slasher, targetEntityClass, true);
        }
    }

    static class SlashingAttackGoal
    extends class_1352 {
        protected final class_1314 mob;
        private final double speed;
        private final boolean pauseWhenMobIdle;
        private class_11 path;
        private double targetX;
        private double targetY;
        private double targetZ;
        private int updateCountdownTicks;
        private int cooldown;
        private int X;
        private final int attackIntervalTicks = 20;
        private long lastUpdateTime;
        private static final long MAX_ATTACK_TIME = 20L;

        public SlashingAttackGoal(class_1314 mob, double speed, boolean pauseWhenMobIdle) {
            this.mob = mob;
            this.speed = speed;
            this.pauseWhenMobIdle = pauseWhenMobIdle;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        }

        public boolean method_6264() {
            long l = this.mob.method_37908().method_8510();
            if (l - this.lastUpdateTime < 20L) {
                return false;
            }
            this.lastUpdateTime = l;
            class_1309 livingEntity = this.mob.method_5968();
            if (livingEntity == null) {
                return false;
            }
            if (!livingEntity.method_5805()) {
                return false;
            }
            this.path = this.mob.method_5942().method_6349((class_1297)livingEntity, 0);
            if (this.path != null) {
                return true;
            }
            return this.mob.method_42150(livingEntity);
        }

        public boolean method_6266() {
            class_1309 livingEntity = this.mob.method_5968();
            if (livingEntity == null) {
                return false;
            }
            if (!livingEntity.method_5805()) {
                return false;
            }
            if (!this.pauseWhenMobIdle) {
                return !this.mob.method_5942().method_6357();
            }
            if (!this.mob.method_18407(livingEntity.method_24515())) {
                return false;
            }
            return !(livingEntity instanceof class_1657) || !livingEntity.method_7325() && !((class_1657)livingEntity).method_7337();
        }

        public void method_6269() {
            this.mob.method_5942().method_6334(this.path, this.speed);
            this.mob.method_19540(true);
            this.updateCountdownTicks = 0;
            this.cooldown = 0;
            this.X = 0;
        }

        public void method_6270() {
            class_1309 livingEntity = this.mob.method_5968();
            if (!class_1301.field_6156.test(livingEntity)) {
                this.mob.method_5980((class_1309)null);
            }
            this.mob.method_19540(false);
            this.mob.method_5942().method_6340();
        }

        public boolean method_38846() {
            return true;
        }

        public void method_6268() {
            class_1309 livingEntity = this.mob.method_5968();
            if (livingEntity != null) {
                this.mob.method_5988().method_6226((class_1297)livingEntity, 30.0f, 30.0f);
                this.updateCountdownTicks = Math.max(this.updateCountdownTicks - 1, 0);
                if ((this.pauseWhenMobIdle || this.mob.method_5985().method_6369((class_1297)livingEntity)) && this.updateCountdownTicks <= 0 && (this.targetX == 0.0 && this.targetY == 0.0 && this.targetZ == 0.0 || livingEntity.method_5649(this.targetX, this.targetY, this.targetZ) >= 1.0 || this.mob.method_59922().method_43057() < 0.05f)) {
                    this.targetX = livingEntity.method_23317();
                    this.targetY = livingEntity.method_23318();
                    this.targetZ = livingEntity.method_23321();
                    this.updateCountdownTicks = 4 + this.mob.method_59922().method_43048(7);
                    double d = this.mob.method_5858((class_1297)livingEntity);
                    if (d > 1024.0) {
                        this.updateCountdownTicks += 10;
                    } else if (d > 256.0) {
                        this.updateCountdownTicks += 5;
                    }
                    if (!this.mob.method_5942().method_6335((class_1297)livingEntity, this.speed)) {
                        this.updateCountdownTicks += 15;
                    }
                    this.updateCountdownTicks = this.method_38847(this.updateCountdownTicks);
                }
                this.cooldown = Math.max(this.cooldown - 1, 0);
                this.attack(livingEntity);
                if (this.X >= 3) {
                    this.resetCooldown();
                    this.X = 0;
                }
            }
        }

        protected void attack(class_1309 target) {
            if (this.canAttack(target) && this.canAttack(target)) {
                this.mob.method_6104(class_1268.field_5808);
                this.mob.method_6121((class_1297)target);
                this.resetCooldownWhileSlashing();
                ++this.X;
            }
        }

        protected void resetCooldownWhileSlashing() {
            this.cooldown = this.method_38847(10);
        }

        protected void resetCooldown() {
            this.cooldown = this.method_38847(55);
        }

        protected boolean isCooledDown() {
            return this.cooldown <= 0;
        }

        protected boolean canAttack(class_1309 target) {
            return this.isCooledDown() && this.mob.method_42150(target) && this.mob.method_5985().method_6369((class_1297)target);
        }

        protected int getCooldown() {
            return this.cooldown;
        }

        protected int getMaxCooldown() {
            return this.method_38847(20);
        }
    }
}

