/*
 * Decompiled with CFR 0.152.
 */
package com.example.mightyrtp.managers;

import com.example.mightyrtp.MightyRTP;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.entity.Player;

public class CooldownManager {
    private final MightyRTP plugin;
    private final Map<UUID, PlayerCooldown> playerCooldowns;

    public CooldownManager(MightyRTP plugin) {
        this.plugin = plugin;
        this.playerCooldowns = new HashMap<UUID, PlayerCooldown>();
    }

    public boolean canUseCommand(Player player) {
        if (player.hasPermission("mightyrtp.bypass")) {
            return true;
        }
        if (!this.plugin.getConfigManager().isCooldownEnabled()) {
            return true;
        }
        UUID playerId = player.getUniqueId();
        PlayerCooldown cooldown = this.playerCooldowns.get(playerId);
        long currentTime = System.currentTimeMillis();
        if (cooldown == null) {
            cooldown = new PlayerCooldown(currentTime);
            cooldown.addUse(currentTime);
            this.playerCooldowns.put(playerId, cooldown);
            return true;
        }
        long cooldownEndTime = cooldown.getStartTime() + (long)(this.plugin.getConfigManager().getCooldownTimeWindow() * 60 * 1000);
        if (currentTime >= cooldownEndTime) {
            cooldown = new PlayerCooldown(currentTime);
            cooldown.addUse(currentTime);
            this.playerCooldowns.put(playerId, cooldown);
            return true;
        }
        if (cooldown.getUseCount() >= this.plugin.getConfigManager().getCooldownMaxUses()) {
            return false;
        }
        cooldown.addUse(currentTime);
        return true;
    }

    public int getRemainingUses(Player player) {
        long cooldownEndTime;
        if (player.hasPermission("mightyrtp.bypass")) {
            return Integer.MAX_VALUE;
        }
        if (!this.plugin.getConfigManager().isCooldownEnabled()) {
            return this.plugin.getConfigManager().getCooldownMaxUses();
        }
        UUID playerId = player.getUniqueId();
        PlayerCooldown cooldown = this.playerCooldowns.get(playerId);
        if (cooldown == null) {
            return this.plugin.getConfigManager().getCooldownMaxUses();
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime >= (cooldownEndTime = cooldown.getStartTime() + (long)(this.plugin.getConfigManager().getCooldownTimeWindow() * 60 * 1000))) {
            return this.plugin.getConfigManager().getCooldownMaxUses();
        }
        return this.plugin.getConfigManager().getCooldownMaxUses() - cooldown.getUseCount();
    }

    public long getTimeUntilReset(Player player) {
        long cooldownEndTime;
        if (player.hasPermission("mightyrtp.bypass")) {
            return 0L;
        }
        if (!this.plugin.getConfigManager().isCooldownEnabled()) {
            return 0L;
        }
        UUID playerId = player.getUniqueId();
        PlayerCooldown cooldown = this.playerCooldowns.get(playerId);
        if (cooldown == null) {
            return 0L;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime >= (cooldownEndTime = cooldown.getStartTime() + (long)(this.plugin.getConfigManager().getCooldownTimeWindow() * 60 * 1000))) {
            return 0L;
        }
        return cooldownEndTime - currentTime;
    }

    public void clearCooldown(Player player) {
        this.playerCooldowns.remove(player.getUniqueId());
    }

    private static class PlayerCooldown {
        private final long startTime;
        private final List<Long> useTimes;

        public PlayerCooldown(long startTime) {
            this.startTime = startTime;
            this.useTimes = new ArrayList<Long>();
        }

        public long getStartTime() {
            return this.startTime;
        }

        public void addUse(long time) {
            this.useTimes.add(time);
        }

        public int getUseCount() {
            return this.useTimes.size();
        }
    }
}

