/*
 * Decompiled with CFR 0.152.
 */
package com.example.mightyrtp.commands;

import com.example.mightyrtp.MightyRTP;
import com.example.mightyrtp.managers.ConfigManager;
import com.example.mightyrtp.managers.CooldownManager;
import com.example.mightyrtp.managers.MessageManager;
import com.example.mightyrtp.utils.TeleportUtils;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class RTPCommand
implements CommandExecutor {
    private final MightyRTP plugin;
    private final ConfigManager configManager;
    private final MessageManager messageManager;
    private final CooldownManager cooldownManager;
    private final TeleportUtils teleportUtils;

    public RTPCommand(MightyRTP plugin) {
        this.plugin = plugin;
        this.configManager = plugin.getConfigManager();
        this.messageManager = plugin.getMessageManager();
        this.cooldownManager = plugin.getCooldownManager();
        this.teleportUtils = new TeleportUtils(plugin);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        Player targetPlayer;
        boolean isConsole;
        boolean bl = isConsole = !(sender instanceof Player);
        if (isConsole) {
            if (args.length >= 2 && args[0].equalsIgnoreCase("player")) {
                String playerName = args[1];
                String worldName = args.length > 2 ? args[2] : null;
                Player targetPlayer2 = Bukkit.getPlayer((String)playerName);
                if (targetPlayer2 == null) {
                    sender.sendMessage("Player " + playerName + " not found!");
                    return true;
                }
                if (worldName != null && !worldName.equalsIgnoreCase("world")) {
                    World targetWorld = Bukkit.getWorld((String)worldName);
                    if (targetWorld != null) {
                        this.executeRTPInWorld(targetPlayer2, targetWorld, sender, true, true);
                        return true;
                    }
                    sender.sendMessage("World " + worldName + " not found!");
                    return true;
                }
                this.executeRTP(targetPlayer2, sender, true, true);
                return true;
            }
            if (args.length >= 1) {
                String playerName = args[0];
                String worldName = args.length > 1 ? args[1] : null;
                Player targetPlayer3 = Bukkit.getPlayer((String)playerName);
                if (targetPlayer3 == null) {
                    sender.sendMessage("Player " + playerName + " not found!");
                    return true;
                }
                if (worldName != null) {
                    World targetWorld = Bukkit.getWorld((String)worldName);
                    if (targetWorld != null) {
                        this.executeRTPInWorld(targetPlayer3, targetWorld, sender, true, true);
                        return true;
                    }
                    sender.sendMessage("World " + worldName + " not found!");
                    return true;
                }
                this.executeRTP(targetPlayer3, sender, true, true);
                return true;
            }
            sender.sendMessage("Console usage:");
            sender.sendMessage("  /rtp player <player> [world]  - BetterRTP format");
            sender.sendMessage("  /rtp <player> [world]         - Direct format");
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("mightyrtp.rtp")) {
            this.messageManager.sendMessage(player, "no-permission");
            return true;
        }
        if (args.length > 0) {
            if (!player.hasPermission("mightyrtp.rtp.other")) {
                this.messageManager.sendMessage(player, "no-permission");
                return true;
            }
            Player foundPlayer = Bukkit.getPlayer((String)args[0]);
            if (foundPlayer == null) {
                String message = this.messageManager.getMessage("player-not-found").replace("{player}", args[0]);
                String formattedMessage = this.messageManager.parseColorTagsToLegacy(message);
                player.sendMessage(formattedMessage);
                return true;
            }
            targetPlayer = foundPlayer;
        } else {
            targetPlayer = player;
        }
        if (args.length > 1) {
            if (!player.hasPermission("mightyrtp.rtp.world")) {
                this.messageManager.sendMessage(player, "no-permission");
                return true;
            }
            String worldName = args[1];
            World targetWorld = Bukkit.getWorld((String)worldName);
            if (targetWorld != null) {
                if (!this.cooldownManager.canUseCommand(targetPlayer)) {
                    long timeUntilReset = this.cooldownManager.getTimeUntilReset(targetPlayer);
                    int minutes = (int)(timeUntilReset / 60000L);
                    int seconds = (int)(timeUntilReset % 60000L / 1000L);
                    String timeString = minutes > 0 ? minutes + " minutes " + seconds + " seconds" : seconds + " seconds";
                    String messageKey = "cooldown-exceeded";
                    String message = this.messageManager.getMessage(messageKey).replace("{time}", timeString);
                    String formattedMessage = this.messageManager.parseColorTagsToLegacy(message);
                    player.sendMessage(formattedMessage);
                    return true;
                }
                if (targetPlayer.hasPermission("mightyrtp.bypass")) {
                    String message = this.messageManager.getMessage("bypass-active");
                    String formattedMessage = this.messageManager.parseColorTagsToLegacy(message);
                    player.sendMessage(formattedMessage);
                }
                this.executeRTPInWorld(targetPlayer, targetWorld, (CommandSender)player, false, false);
                return true;
            }
            this.messageManager.sendMessage(player, "world-not-found");
            return true;
        }
        if (!this.cooldownManager.canUseCommand(targetPlayer)) {
            long timeUntilReset = this.cooldownManager.getTimeUntilReset(targetPlayer);
            int minutes = (int)(timeUntilReset / 60000L);
            int seconds = (int)(timeUntilReset % 60000L / 1000L);
            String timeString = minutes > 0 ? minutes + " minutes " + seconds + " seconds" : seconds + " seconds";
            String messageKey = "cooldown-exceeded";
            String message = this.messageManager.getMessage(messageKey).replace("{time}", timeString);
            String formattedMessage = this.messageManager.parseColorTagsToLegacy(message);
            player.sendMessage(formattedMessage);
            return true;
        }
        if (targetPlayer.hasPermission("mightyrtp.bypass")) {
            String message = this.messageManager.getMessage("bypass-active");
            String formattedMessage = this.messageManager.parseColorTagsToLegacy(message);
            player.sendMessage(formattedMessage);
        }
        this.executeRTP(targetPlayer, (CommandSender)player, false, false);
        return true;
    }

    private void executeRTP(Player targetPlayer, CommandSender sender, boolean isConsole, boolean fastMode) {
        if (this.configManager.isWorldBlacklisted(targetPlayer.getWorld().getName())) {
            if (isConsole) {
                sender.sendMessage("World " + targetPlayer.getWorld().getName() + " is blacklisted for RTP!");
            } else {
                this.messageManager.sendMessage((Player)sender, "world-blacklisted");
            }
            return;
        }
        if (!isConsole || this.configManager.shouldShowTitlesForConsole()) {
            this.messageManager.showTitle(targetPlayer);
        }
        if (isConsole) {
            sender.sendMessage("Teleporting " + targetPlayer.getName() + " to random location...");
            this.messageManager.sendMessage(targetPlayer, "teleporting");
        } else {
            Player player = (Player)sender;
            if (targetPlayer.equals((Object)player)) {
                this.messageManager.sendMessage(player, "teleporting");
            } else {
                String message = this.messageManager.getMessage("teleporting-other").replace("{player}", targetPlayer.getName());
                String formattedMessage = this.messageManager.parseColorTagsToLegacy(message);
                player.sendMessage(formattedMessage);
                this.messageManager.sendMessage(targetPlayer, "teleporting");
            }
        }
        this.teleportUtils.findSafeLocationAsync(targetPlayer.getWorld(), targetPlayer.getLocation(), targetPlayer, result -> {
            if (result.isSuccess()) {
                targetPlayer.teleport(result.getLocation());
                if (isConsole) {
                    sender.sendMessage("Successfully teleported " + targetPlayer.getName() + " to random location!");
                    this.messageManager.sendMessage(targetPlayer, "teleported");
                } else {
                    Player player = (Player)sender;
                    if (targetPlayer.equals((Object)player)) {
                        this.messageManager.sendMessage(player, "teleported");
                    } else {
                        String message = this.messageManager.getMessage("teleported-other").replace("{player}", targetPlayer.getName());
                        String formattedMessage = this.messageManager.parseColorTagsToLegacy(message);
                        player.sendMessage(formattedMessage);
                        this.messageManager.sendMessage(targetPlayer, "teleported");
                    }
                }
            } else if (result.isTimeout()) {
                if (isConsole) {
                    sender.sendMessage("Failed to teleport " + targetPlayer.getName() + ": Search timeout!");
                    this.messageManager.sendMessage(targetPlayer, "search-timeout");
                } else {
                    Player player = (Player)sender;
                    if (targetPlayer.equals((Object)player)) {
                        this.messageManager.sendMessage(player, "search-timeout");
                    } else {
                        String message = this.messageManager.getMessage("search-timeout");
                        String formattedMessage = this.messageManager.parseColorTagsToLegacy(message);
                        player.sendMessage(formattedMessage);
                        this.messageManager.sendMessage(targetPlayer, "search-timeout");
                    }
                }
            } else if (isConsole) {
                sender.sendMessage("Failed to teleport " + targetPlayer.getName() + ": No safe location found!");
                this.messageManager.sendMessage(targetPlayer, "no-safe-location");
            } else {
                Player player = (Player)sender;
                if (targetPlayer.equals((Object)player)) {
                    this.messageManager.sendMessage(player, "no-safe-location");
                } else {
                    String message = this.messageManager.getMessage("no-safe-location-other").replace("{player}", targetPlayer.getName());
                    String formattedMessage = this.messageManager.parseColorTagsToLegacy(message);
                    player.sendMessage(formattedMessage);
                    this.messageManager.sendMessage(targetPlayer, "no-safe-location");
                }
            }
        });
    }

    private void executeRTPInWorld(Player targetPlayer, World targetWorld, CommandSender sender, boolean isConsole, boolean fastMode) {
        if (this.configManager.isWorldBlacklisted(targetWorld.getName())) {
            if (isConsole) {
                sender.sendMessage("World " + targetWorld.getName() + " is blacklisted for RTP!");
            } else {
                this.messageManager.sendMessage((Player)sender, "world-blacklisted");
            }
            return;
        }
        if (!isConsole || this.configManager.shouldShowTitlesForConsole()) {
            this.messageManager.showTitle(targetPlayer);
        }
        if (isConsole) {
            sender.sendMessage("Teleporting " + targetPlayer.getName() + " to random location in " + targetWorld.getName() + "...");
            this.messageManager.sendMessage(targetPlayer, "teleporting");
        } else {
            Player player = (Player)sender;
            if (targetPlayer.equals((Object)player)) {
                this.messageManager.sendMessage(player, "teleporting");
            } else {
                String message = this.messageManager.getMessage("teleporting-other").replace("{player}", targetPlayer.getName());
                String formattedMessage = this.messageManager.parseColorTagsToLegacy(message);
                player.sendMessage(formattedMessage);
                this.messageManager.sendMessage(targetPlayer, "teleporting");
            }
        }
        this.teleportUtils.findSafeLocationAsync(targetWorld, targetPlayer.getLocation(), targetPlayer, result -> {
            if (result.isSuccess()) {
                targetPlayer.teleport(result.getLocation());
                if (isConsole) {
                    sender.sendMessage("Successfully teleported " + targetPlayer.getName() + " to random location in " + targetWorld.getName() + "!");
                    this.messageManager.sendMessage(targetPlayer, "teleported");
                } else {
                    Player player = (Player)sender;
                    if (targetPlayer.equals((Object)player)) {
                        this.messageManager.sendMessage(player, "teleported");
                    } else {
                        String message = this.messageManager.getMessage("teleported-other").replace("{player}", targetPlayer.getName());
                        String formattedMessage = this.messageManager.parseColorTagsToLegacy(message);
                        player.sendMessage(formattedMessage);
                        this.messageManager.sendMessage(targetPlayer, "teleported");
                    }
                }
            } else if (result.isTimeout()) {
                if (isConsole) {
                    sender.sendMessage("Failed to teleport " + targetPlayer.getName() + ": Search timeout!");
                    this.messageManager.sendMessage(targetPlayer, "search-timeout");
                } else {
                    Player player = (Player)sender;
                    if (targetPlayer.equals((Object)player)) {
                        this.messageManager.sendMessage(player, "search-timeout");
                    } else {
                        String message = this.messageManager.getMessage("search-timeout");
                        String formattedMessage = this.messageManager.parseColorTagsToLegacy(message);
                        player.sendMessage(formattedMessage);
                        this.messageManager.sendMessage(targetPlayer, "search-timeout");
                    }
                }
            } else if (isConsole) {
                sender.sendMessage("Failed to teleport " + targetPlayer.getName() + ": No safe location found!");
                this.messageManager.sendMessage(targetPlayer, "no-safe-location");
            } else {
                Player player = (Player)sender;
                if (targetPlayer.equals((Object)player)) {
                    this.messageManager.sendMessage(player, "no-safe-location");
                } else {
                    String message = this.messageManager.getMessage("no-safe-location-other").replace("{player}", targetPlayer.getName());
                    String formattedMessage = this.messageManager.parseColorTagsToLegacy(message);
                    player.sendMessage(formattedMessage);
                    this.messageManager.sendMessage(targetPlayer, "no-safe-location");
                }
            }
        });
    }
}

